/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.IntStream;

public class ReflectionUtils {
    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype) {
        return ReflectionUtils.getPrivateFieldValueByType(o, objectClasstype, fieldClasstype, 0);
    }

    public static Object getPrivateFieldValueByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype, int index) {
        Field[] fields;
        Class<?> objectClass = o != null ? o.getClass() : objectClasstype;
        while (!objectClass.equals(objectClasstype) && objectClass.getSuperclass() != null) {
            objectClass = objectClass.getSuperclass();
        }
        int counter = 0;
        for (Field field : fields = objectClass.getDeclaredFields()) {
            if (!fieldClasstype.equals(field.getType())) continue;
            if (counter == index) {
                try {
                    field.setAccessible(true);
                    return field.get(o);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++counter;
        }
        return null;
    }

    public static Object getFieldValueByName(Object o, String fieldName) {
        Field[] fields;
        for (Field field : fields = o.getClass().getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            try {
                field.setAccessible(true);
                return field.get(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArrayList<Field> getFieldsByType(Object o, Class<?> objectClassBaseType, Class<?> fieldClasstype) {
        ArrayList<Field> matches = new ArrayList<Field>();
        Class<?> objectClass = o.getClass();
        while (!objectClass.equals(objectClassBaseType) && objectClass.getSuperclass() != null) {
            Field[] fields;
            for (Field field : fields = objectClass.getDeclaredFields()) {
                if (!fieldClasstype.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                matches.add(field);
            }
            objectClass = objectClass.getSuperclass();
        }
        return matches;
    }

    public static Field getFieldByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype) {
        return ReflectionUtils.getFieldByType(o, objectClasstype, fieldClasstype, 0);
    }

    public static Field getFieldByType(Object o, Class<?> objectClasstype, Class<?> fieldClasstype, int index) {
        Field[] fields;
        Class<?> objectClass = o.getClass();
        while (!objectClass.equals(objectClasstype) && objectClass.getSuperclass() != null) {
            objectClass = objectClass.getSuperclass();
        }
        int counter = 0;
        for (Field field : fields = objectClass.getDeclaredFields()) {
            if (!fieldClasstype.equals(field.getType())) continue;
            if (counter == index) {
                field.setAccessible(true);
                return field;
            }
            ++counter;
        }
        return null;
    }

    public static Method getMethodByType(Class<?> objectType, Class<?> returnType, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethodByType(0, objectType, returnType, parameterTypes);
    }

    public static Method getMethodByType(int index, Class<?> objectType, Class<?> returnType, Class<?> ... parameterTypes) {
        Method[] methods = objectType.getDeclaredMethods();
        int counter = 0;
        for (Method method : methods) {
            if (!returnType.equals(method.getReturnType())) continue;
            Class[] methodParameterTypes = method.getParameterTypes();
            if (parameterTypes.length == methodParameterTypes.length) {
                boolean match = IntStream.range(0, parameterTypes.length).noneMatch(t -> parameterTypes[t] != methodParameterTypes[t]);
                if (counter == index && match) {
                    method.setAccessible(true);
                    return method;
                }
            }
            ++counter;
        }
        return null;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException var2) {
            return false;
        }
    }
}

