/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.DefaultErosionConfig;
import com._13rac1.erosion.common.IErosionConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class ErodableBlocks {
    public static IErosionConfig Config = new DefaultErosionConfig();
    private static final Integer MAX_RESIST_ODDS = 0;
    private static final Integer SOURCE_BREAK_RESIST_ODDS = 8;
    private static final Integer LEAF_RESIST_ODDS = 1;
    private static final Integer SAND_RESIST_ODDS = 1;
    private static final Integer WOOL_RESIST_ODDS = 1;
    private static final Integer GRAVEL_RESIST_ODDS = 2;
    private static final Integer CLAY_RESIST_ODDS = 5;
    private static final Integer DIRT_RESIST_ODDS = 4;
    private static final Integer GRASS_RESIST_ODDS = 6;
    private static final Integer COBBLE_RESIST_ODDS = 20;
    private static final Integer BRICK_RESIST_ODDS = 25;
    private static final Integer DECAY_ALWAYS_ODDS = 0;
    private static final Integer DECAY_NEVER_ODDS = 100;
    private static final Integer DECAY_TO_AIR_ODDS = 0;
    private static final Integer DECAY_TO_SAND_ODDS = 1;
    private static final Integer DECAY_TO_GRAVEL_ODDS = 0;
    private static final Integer DECAY_TO_CLAY_ODDS = 20;
    private static final Integer DECAY_TO_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_COARSE_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_MOSSY_COBBLE_ODDS = 0;
    private static final Integer DECAY_TO_MOSSY_BRICKS_ODDS = 1;
    private static HashMap<class_2248, Integer> decayables;
    private static HashMap<class_2248, Erodable> erodables;

    private static HashMap<class_2248, Integer> getDecayables() {
        if (decayables == null) {
            decayables = new HashMap();
            decayables.put(class_2246.field_10124, DECAY_TO_AIR_ODDS);
            decayables.put(class_2246.field_10460, DECAY_TO_CLAY_ODDS);
            decayables.put(class_2246.field_10102, DECAY_TO_SAND_ODDS);
            decayables.put(class_2246.field_10255, DECAY_TO_GRAVEL_ODDS);
            decayables.put(class_2246.field_10566, DECAY_TO_DIRT_ODDS);
            decayables.put(class_2246.field_10253, DECAY_TO_COARSE_DIRT_ODDS);
            decayables.put(class_2246.field_9989, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(class_2246.field_10405, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(class_2246.field_10207, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(class_2246.field_9990, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(class_2246.field_10065, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(class_2246.field_10024, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(class_2246.field_10173, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(class_2246.field_10059, DECAY_TO_MOSSY_BRICKS_ODDS);
        }
        return decayables;
    }

    private static HashMap<class_2248, Erodable> getErodables() {
        if (erodables == null) {
            erodables = new HashMap();
            erodables.put(class_2246.field_10460, new Erodable(CLAY_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10534, new Erodable(SAND_RESIST_ODDS, class_2246.field_10460));
            erodables.put(class_2246.field_10102, new Erodable(SAND_RESIST_ODDS, class_2246.field_10460));
            erodables.put(class_2246.field_10255, new Erodable(GRAVEL_RESIST_ODDS, class_2246.field_10102));
            erodables.put(class_2246.field_10253, new Erodable(DIRT_RESIST_ODDS, class_2246.field_10255));
            if (Config.GetErodeFarmLand().booleanValue()) {
                erodables.put(class_2246.field_10362, new Erodable(DIRT_RESIST_ODDS, class_2246.field_10253));
            }
            erodables.put(class_2246.field_10566, new Erodable(DIRT_RESIST_ODDS, class_2246.field_10253));
            erodables.put(class_2246.field_10520, new Erodable(DIRT_RESIST_ODDS, class_2246.field_10253));
            erodables.put(class_2246.field_10219, new Erodable(GRASS_RESIST_ODDS, class_2246.field_10566));
            erodables.put(class_2246.field_10479, new Erodable(GRASS_RESIST_ODDS, class_2246.field_10566));
            erodables.put(class_2246.field_10194, new Erodable(GRASS_RESIST_ODDS, class_2246.field_10479));
            erodables.put(class_2246.field_9989, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10255));
            erodables.put(class_2246.field_10405, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10207, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_9990, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10445, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_9989));
            erodables.put(class_2246.field_10351, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10405));
            erodables.put(class_2246.field_10596, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10207));
            erodables.put(class_2246.field_10625, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_9990));
            erodables.put(class_2246.field_10065, new Erodable(BRICK_RESIST_ODDS, class_2246.field_10255));
            erodables.put(class_2246.field_10024, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10173, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10059, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10124));
            erodables.put(class_2246.field_10056, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10065));
            erodables.put(class_2246.field_10131, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10024));
            erodables.put(class_2246.field_10392, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10173));
            erodables.put(class_2246.field_10252, new Erodable(COBBLE_RESIST_ODDS, class_2246.field_10059));
            erodables.forEach((block, erodable) -> {
                Erodable current = erodable;
                while (current.decayBlock != class_2246.field_10124) {
                    erodable.decayList.add(current.decayBlock);
                    current = erodables.get(current.decayBlock);
                }
            });
        }
        return erodables;
    }

    public static Integer getResistance(class_2248 block) {
        if (ErodableBlocks.getErodables().containsKey(block)) {
            return ErodableBlocks.getErodables().get((Object)block).resistanceOdds;
        }
        class_2680 bs = block.method_9564();
        if (bs.method_26164(class_3481.field_15503)) {
            return LEAF_RESIST_ODDS;
        }
        if (bs.method_26164(class_3481.field_15466)) {
            return SAND_RESIST_ODDS;
        }
        if (bs.method_26164(class_3481.field_15481)) {
            return WOOL_RESIST_ODDS;
        }
        return MAX_RESIST_ODDS;
    }

    public static boolean canErode(class_2248 block) {
        return ErodableBlocks.getResistance(block) != MAX_RESIST_ODDS;
    }

    public static boolean maybeErode(Random rand, class_2248 block) {
        return rand.nextInt(ErodableBlocks.getResistance(block)) == 0;
    }

    public static class_2248 maybeDecay(Random rand, class_2248 block) {
        Integer odds = DECAY_NEVER_ODDS;
        class_2248 decayToBlock = class_2246.field_10124;
        if (ErodableBlocks.getErodables().containsKey(block)) {
            decayToBlock = ErodableBlocks.getErodables().get((Object)block).decayBlock;
        }
        if (!ErodableBlocks.getDecayables().containsKey(decayToBlock)) {
            return class_2246.field_10124;
        }
        odds = ErodableBlocks.getDecayables().get(decayToBlock);
        if (odds == DECAY_NEVER_ODDS) {
            return class_2246.field_10124;
        }
        if (odds == DECAY_ALWAYS_ODDS) {
            return decayToBlock;
        }
        if (rand.nextInt(odds) == 0) {
            return decayToBlock;
        }
        return class_2246.field_10124;
    }

    public static class_2248 decayTo(class_2248 block) {
        HashMap<class_2248, Erodable> erodables = ErodableBlocks.getErodables();
        if (erodables.containsKey(block)) {
            return erodables.get((Object)block).decayBlock;
        }
        return class_2246.field_10124;
    }

    public static boolean canSourceBreak(class_2248 block) {
        return ErodableBlocks.getResistance(block) < SOURCE_BREAK_RESIST_ODDS;
    }

    public static ArrayList<class_2248> getDecayList(class_2248 block) {
        return ErodableBlocks.getErodables().get((Object)block).decayList;
    }

    static class Erodable {
        Integer resistanceOdds;
        class_2248 decayBlock;
        ArrayList<class_2248> decayList;

        Erodable(Integer resistanceOdds, class_2248 decayBlock) {
            this.resistanceOdds = resistanceOdds;
            this.decayBlock = decayBlock;
            this.decayList = new ArrayList();
        }
    }
}

