/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3610;

public class Tasks {
    private static final class_2382 VECTOR_DOWN = new class_2382(0, -1, 0);
    private static final class_2382 VECTOR_UP = new class_2382(0, 1, 0);
    private static final class_2382 VECTOR_NORTH = new class_2382(0, 0, -1);
    private static final class_2382 VECTOR_NORTH_EAST = new class_2382(1, 0, -1);
    private static final class_2382 VECTOR_EAST = new class_2382(1, 0, 0);
    private static final class_2382 VECTOR_SOUTH_EAST = new class_2382(1, 0, 1);
    private static final class_2382 VECTOR_SOUTH = new class_2382(0, 0, 1);
    private static final class_2382 VECTOR_SOUTH_WEST = new class_2382(-1, 0, 1);
    private static final class_2382 VECTOR_WEST = new class_2382(-1, 0, 0);
    private static final class_2382 VECTOR_NORTH_WEST = new class_2382(-1, 0, -1);
    private static final List<class_2382> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<class_2382> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<class_2382> posEightAroundUp = Arrays.asList(new class_2382(1, 1, 1), new class_2382(1, 1, 0), new class_2382(1, 1, -1), new class_2382(0, 1, -1), new class_2382(-1, 1, -1), new class_2382(-1, 1, 0), new class_2382(-1, 1, 1), new class_2382(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);
    public final int AIR_WATER_NOT_FOUND = 128;

    public void run(class_1937 world, class_2680 state, class_2338 pos, Random rand) {
        Integer level = (Integer)state.method_11654((class_2769)class_2404.field_11278);
        this.maybeSourceBreak(world, state, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(world, state, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(world, state, pos, rand, level);
        this.maybeDecayUnder(world, state, pos, rand, level);
    }

    public class_243 getFlowVelocity(class_1937 world, class_2338 pos, class_2680 state) {
        class_3610 fluidState = state.method_26227();
        return fluidState.method_15758((class_1922)world, pos);
    }

    public Boolean isFluidBlock(class_2248 block) {
        return block instanceof class_2404;
    }

    public class_2248 getBlock(class_1937 world, class_2338 pos) {
        class_2680 bs = world.method_8320(pos);
        return bs.method_26204();
    }

    protected boolean maybeErodeEdge(class_1937 world, class_2680 state, class_2338 pos, Random rand, Integer level) {
        class_2338 underPos = pos.method_10074();
        class_2248 underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return false;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return false;
        }
        class_2248 decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != class_2246.field_10124) {
            world.method_8501(underPos, decayBlock.method_9564());
            return true;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.method_8501(underPos, (class_2680)class_2246.field_10382.method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)underBlocklevel));
        if (state.method_11654((class_2769)class_2404.field_11278) == FluidLevel.SOURCE) {
            return false;
        }
        world.method_8501(pos, class_2246.field_10124.method_9564());
        Integer upDeleteCount = 0;
        class_2338 posUp = pos.method_10084();
        while (this.isFluidBlock(this.getBlock(world, posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            upDeleteCount = upDeleteCount + 1;
            if (upDeleteCount > 3 || world.method_8320(posUp).method_11654((class_2769)class_2404.field_11278) == FluidLevel.SOURCE) break;
            world.method_8501(posUp, class_2246.field_10124.method_9564());
            posUp = posUp.method_10084();
        }
        return true;
    }

    protected boolean isEdge(class_1937 world, class_2338 pos) {
        List<class_2338> listSidePos = Arrays.asList(pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067());
        for (class_2338 sidePos : listSidePos) {
            class_2338 underPos = sidePos.method_10074();
            class_2248 underBlock = this.getBlock(world, underPos);
            if (!this.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected class_2382 dirTurnLeft(class_2382 in) {
        return in.method_10259(VECTOR_DOWN);
    }

    protected class_2382 dirTurnRight(class_2382 in) {
        return in.method_10259(VECTOR_UP);
    }

    protected boolean treeInColumn(class_1937 world, class_2338 pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        class_2338 currentPos = pos.method_10084();
        while (count < MAX_UP) {
            class_2680 bs = world.method_8320(currentPos);
            class_2248 currentBlock = bs.method_26204();
            if (bs.method_26164(class_3481.field_15475)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            count = count + 1;
            currentPos = currentPos.method_10084();
        }
        return false;
    }

    protected boolean maybeFlowingWall(class_1937 world, class_2680 state, class_2338 pos, Random rand, Integer level) {
        class_2382 dirForward;
        class_2382 shortestDir;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        class_243 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.field_1352) < 0.8 && Math.abs(velocity.field_1350) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if ((shortestDir = this.findShortestDirectionToAirOrWater(world, pos, level, dirForward = new class_2382((int)Math.round(velocity.field_1352), (int)velocity.field_1351 + Flow7Adjust, (int)Math.round(velocity.field_1350)))) == null) {
            return false;
        }
        class_2338 flowPos = pos.method_10081(shortestDir);
        class_2248 wallBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.method_8501(flowPos, class_2246.field_10124.method_9564());
        return true;
    }

    protected class_2382 findShortestDirectionToAirOrWater(class_1937 world, class_2338 pos, Integer level, class_2382 dirForward) {
        Integer dist;
        class_2338 posForward = pos.method_10081(dirForward);
        class_2248 blockForward = this.getBlock(world, posForward);
        if (this.isAir(blockForward) || blockForward == class_2246.field_10382 || blockForward == class_2246.field_10164) {
            return null;
        }
        class_2382 dirLeft = this.dirTurnLeft(dirForward);
        class_2382 dirRight = this.dirTurnRight(dirForward);
        class_2338 posLeft = pos.method_10081(dirLeft);
        class_2338 posRight = pos.method_10081(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(this.getBlock(world, posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(this.getBlock(world, posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return null;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            options.add(new wallBreakOption(dirForward, dist));
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            options.add(new wallBreakOption(dirLeft, dist));
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            options.add(new wallBreakOption(dirRight, dist));
        }
        if (options.size() == 0) {
            return null;
        }
        Integer shortestDistance = 128;
        class_2382 shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        return shortestDir;
    }

    private void maybeSourceBreak(class_1937 world, class_2680 state, class_2338 pos, Random rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.method_10264() < world.method_8615()) {
            return;
        }
        class_2248 upBlock = world.method_8320(pos.method_10084()).method_26204();
        if (!this.isAir(upBlock)) {
            return;
        }
        class_243 velocity = this.getFlowVelocity(world, pos, state);
        if (velocity.method_1033() > 0.0) {
            return;
        }
        List<class_2382> listDirection = Arrays.asList(new class_2382(1, 0, 0), new class_2382(-1, 0, 0), new class_2382(0, 0, 1), new class_2382(0, 0, -1));
        Collections.shuffle(listDirection);
        for (class_2382 dir : listDirection) {
            Integer dist;
            class_2338 sidePos = pos.method_10081(dir);
            class_2248 sideBlock = this.getBlock(world, sidePos);
            if (sideBlock == class_2246.field_10382 || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || (dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level)) == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                class_2382 waterDirection = new class_2382(-dir.method_10263() * waterMultipler, dir.method_10264(), -dir.method_10260() * waterMultipler);
                class_2338 maybeWaterPos = pos.method_10081(waterDirection);
                class_2680 maybeWaterState = world.method_8320(maybeWaterPos);
                if (maybeWaterState.method_26204() != class_2246.field_10382) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.method_8501(sidePos, class_2246.field_10124.method_9564());
            return;
        }
    }

    private boolean isAir(class_2248 block) {
        return block == class_2246.field_10124 || block == class_2246.field_10543;
    }

    protected Integer distanceToAirWaterInFlowPath(class_1937 world, class_2338 pos, class_2382 dir, Integer level) {
        class_2248 blockCurrent;
        class_2680 blockstateCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        class_2338 posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockstateCurrent = world.method_8320(posCurrent = posCurrent.method_10081(dir));
            blockCurrent = blockstateCurrent.method_26204();
            if (this.isAir(blockCurrent) || blockstateCurrent.method_26164(class_3481.field_15503) || blockCurrent == class_2246.field_10382) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.method_10074();
        flowDistanceRemaining = 8;
        while (flowDistanceRemaining > 0) {
            blockstateCurrent = world.method_8320(posCurrent);
            blockCurrent = blockstateCurrent.method_26204();
            if (this.isAir(blockCurrent) || blockstateCurrent.method_26164(class_3481.field_15503) || blockCurrent == class_2246.field_10382) {
                return distanceToAirWater;
            }
            if (!ErodableBlocks.canErode(blockCurrent)) {
                return 128;
            }
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            posCurrent = posCurrent.method_10081(dir);
        }
        return 128;
    }

    protected boolean maybeDecayUnder(class_1937 world, class_2680 state, class_2338 pos, Random rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        class_2338 underPos = pos.method_10074();
        class_2248 underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        class_2248 decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == class_2246.field_10124) {
            return false;
        }
        class_243 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.field_1352) < 0.8 && Math.abs(velocity.field_1350) < 0.8) {
            return false;
        }
        class_2338 flowPos = underPos.method_10081(new class_2382((int)Math.round(velocity.field_1352), 0, (int)Math.round(velocity.field_1350)));
        class_2248 flowBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.method_8501(underPos, decayTo.method_9564());
        return true;
    }

    protected boolean isCobbleStone(class_2248 block) {
        return block == class_2246.field_10445 || block == class_2246.field_10625 || block == class_2246.field_10596 || block == class_2246.field_10625;
    }

    protected boolean isStoneBricks(class_2248 block) {
        return block == class_2246.field_10056 || block == class_2246.field_10252 || block == class_2246.field_10392 || block == class_2246.field_10252;
    }

    protected boolean maybeAddMoss(class_1937 world, class_2338 pos, Random rand) {
        List<class_2382> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<class_2382> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            class_2382 dir = iterator.next();
            class_2338 sidePos = pos.method_10081(dir);
            class_2248 sideBlock = this.getBlock(world, sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            class_2248 mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == class_2246.field_10124) {
                return false;
            }
            world.method_8501(sidePos, mossBlock.method_9564());
            return true;
        }
        return false;
    }

    private class wallBreakOption {
        class_2382 dir;
        Integer distance;

        public wallBreakOption(class_2382 dir, Integer distance) {
            this.dir = dir;
            this.distance = distance;
        }
    }
}

