/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_5819;

public class Tasks {
    private static final class_2382 VECTOR_DOWN = new class_2382(0, -1, 0);
    private static final class_2382 VECTOR_UP = new class_2382(0, 1, 0);
    private static final class_2382 VECTOR_NORTH = new class_2382(0, 0, -1);
    private static final class_2382 VECTOR_NORTH_EAST = new class_2382(1, 0, -1);
    private static final class_2382 VECTOR_EAST = new class_2382(1, 0, 0);
    private static final class_2382 VECTOR_SOUTH_EAST = new class_2382(1, 0, 1);
    private static final class_2382 VECTOR_SOUTH = new class_2382(0, 0, 1);
    private static final class_2382 VECTOR_SOUTH_WEST = new class_2382(-1, 0, 1);
    private static final class_2382 VECTOR_WEST = new class_2382(-1, 0, 0);
    private static final class_2382 VECTOR_NORTH_WEST = new class_2382(-1, 0, -1);
    private static final List<class_2382> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<class_2382> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<class_2382> posEightAroundUp = Arrays.asList(new class_2382(1, 1, 1), new class_2382(1, 1, 0), new class_2382(1, 1, -1), new class_2382(0, 1, -1), new class_2382(-1, 1, -1), new class_2382(-1, 1, 0), new class_2382(-1, 1, 1), new class_2382(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);

    public void run(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
        Integer level = (Integer)state.method_11654((class_2769)class_2404.field_11278);
        this.maybeSourceBreak(state, world, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(state, world, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(state, world, pos, rand, level);
        this.maybeDecayUnder(state, world, pos, rand, level);
    }

    public class_243 getFlowVelocity(class_1937 world, class_2680 state, class_2338 pos) {
        class_3610 fluidState = state.method_26227();
        return fluidState.method_15758((class_1922)world, pos);
    }

    public Boolean isFluidBlock(class_2248 block) {
        return block instanceof class_2404;
    }

    public class_2248 getBlock(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26204();
    }

    private void maybeErodeEdge(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand, Integer level) {
        class_2338 underPos = pos.method_10074();
        class_2248 underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return;
        }
        class_2248 decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != class_2246.field_10124) {
            world.method_8501(underPos, decayBlock.method_9564());
            return;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.method_8501(underPos, (class_2680)class_2246.field_10382.method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)underBlocklevel));
        if (state.method_11654((class_2769)class_2404.field_11278) == FluidLevel.SOURCE) {
            return;
        }
        world.method_8501(pos, class_2246.field_10124.method_9564());
        Integer upDeleteCount = 0;
        class_2338 posUp = pos.method_10084();
        while (this.isFluidBlock(this.getBlock(world, posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            upDeleteCount = upDeleteCount + 1;
            if (upDeleteCount > 3 || world.method_8320(posUp).method_11654((class_2769)class_2404.field_11278) == FluidLevel.SOURCE) break;
            world.method_8501(posUp, class_2246.field_10124.method_9564());
            posUp = posUp.method_10084();
        }
    }

    protected boolean isEdge(class_1937 world, class_2338 pos) {
        List<class_2338> listSidePos = Arrays.asList(pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067());
        for (class_2338 sidePos : listSidePos) {
            class_2338 underPos = sidePos.method_10074();
            class_2248 underBlock = this.getBlock(world, underPos);
            if (!this.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected class_2382 dirTurnLeft(class_2382 in) {
        return in.method_10259(VECTOR_DOWN);
    }

    protected class_2382 dirTurnRight(class_2382 in) {
        return in.method_10259(VECTOR_UP);
    }

    protected boolean treeInColumn(class_1937 world, class_2338 pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        class_2338 currentPos = pos.method_10084();
        while (count < MAX_UP) {
            class_2248 currentBlock = this.getBlock(world, currentPos);
            class_2680 currentBlockState = world.method_8320(currentPos);
            if (currentBlockState.method_26164(class_3481.field_15475)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            count = count + 1;
            currentPos = currentPos.method_10084();
        }
        return false;
    }

    private boolean maybeFlowingWall(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand, Integer level) {
        wallBreakOption opt;
        Integer dist;
        class_2382 dirForward;
        class_2338 posForward;
        class_2248 blockForward;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        class_243 velocity = this.getFlowVelocity(world, state, pos);
        if (Math.abs(velocity.field_1352) < 0.8 && Math.abs(velocity.field_1350) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if (this.isAir(blockForward = this.getBlock(world, posForward = pos.method_10081(dirForward = new class_2382((int)Math.round(velocity.field_1352), (int)velocity.field_1351 + Flow7Adjust, (int)Math.round(velocity.field_1350))))) || blockForward == class_2246.field_10382 || blockForward == class_2246.field_10164) {
            return false;
        }
        class_2382 dirLeft = this.dirTurnLeft(dirForward);
        class_2382 dirRight = this.dirTurnRight(dirForward);
        class_2338 posLeft = pos.method_10081(dirLeft);
        class_2338 posRight = pos.method_10081(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(this.getBlock(world, posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(this.getBlock(world, posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return false;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirForward;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirLeft;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirRight;
            opt.distance = dist;
            options.add(opt);
        }
        if (options.size() == 0) {
            return false;
        }
        Integer shortestDistance = 128;
        class_2382 shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        if (shortestDir == null) {
            return false;
        }
        class_2338 flowPos = pos.method_10081(shortestDir);
        class_2338 aboveFlowPos = flowPos.method_10084();
        class_2680 aboveFlowBlockState = world.method_8320(aboveFlowPos);
        if (aboveFlowBlockState.method_26164(class_3481.field_15475)) {
            return false;
        }
        class_2248 wallBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.canErode(wallBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.method_8501(flowPos, class_2246.field_10124.method_9564());
        return true;
    }

    private void maybeSourceBreak(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.method_10264() < world.method_8615()) {
            return;
        }
        class_2248 upBlock = world.method_8320(pos.method_10084()).method_26204();
        if (!this.isAir(upBlock)) {
            return;
        }
        class_243 velocity = this.getFlowVelocity(world, state, pos);
        if (velocity.method_1033() > 0.0) {
            return;
        }
        List<class_2382> listDirection = Arrays.asList(new class_2382(1, 0, 0), new class_2382(-1, 0, 0), new class_2382(0, 0, 1), new class_2382(0, 0, -1));
        Collections.shuffle(listDirection);
        for (class_2382 dir : listDirection) {
            Integer dist;
            class_2338 sidePos = pos.method_10081(dir);
            class_2248 sideBlock = this.getBlock(world, sidePos);
            if (sideBlock == class_2246.field_10382 || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || (dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level)) == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                class_2382 waterDirection = new class_2382(-dir.method_10263() * waterMultipler, dir.method_10264(), -dir.method_10260() * waterMultipler);
                class_2338 maybeWaterPos = pos.method_10081(waterDirection);
                class_2680 maybeWaterState = world.method_8320(maybeWaterPos);
                if (maybeWaterState.method_26204() != class_2246.field_10382) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.method_8501(sidePos, class_2246.field_10124.method_9564());
            return;
        }
    }

    private boolean isAir(class_2248 block) {
        return block == class_2246.field_10124 || block == class_2246.field_10543;
    }

    protected boolean airInFlowPath(class_1937 world, class_2338 pos, class_2382 dir) {
        int yDeeper = 0;
        for (int airMultipler : Arrays.asList(7, 14)) {
            class_2382 airDirection = new class_2382(dir.method_10263() * airMultipler, dir.method_10264() - yDeeper, dir.method_10260() * airMultipler);
            ++yDeeper;
            class_2338 maybeAirPos = pos.method_10081(airDirection);
            class_2248 maybeAirBlock = this.getBlock(world, maybeAirPos);
            class_2680 maybeAirBlockState = world.method_8320(pos);
            if (!this.isAir(maybeAirBlock) && !maybeAirBlockState.method_26164(class_3481.field_15503)) continue;
            return true;
        }
        return false;
    }

    protected Integer distanceToAirWaterInFlowPath(class_1937 world, class_2338 pos, class_2382 dir, Integer level) {
        class_2680 blockstateCurrent;
        class_2248 blockCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        class_2338 posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            posCurrent = posCurrent.method_10081(dir);
            blockCurrent = this.getBlock(world, posCurrent);
            blockstateCurrent = world.method_8320(posCurrent);
            if (this.isAir(blockCurrent) || blockstateCurrent.method_26164(class_3481.field_15503) || blockCurrent == class_2246.field_10382) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.method_10074();
        flowDistanceRemaining = 7;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            posCurrent = posCurrent.method_10081(dir);
            blockCurrent = this.getBlock(world, posCurrent);
            blockstateCurrent = world.method_8320(posCurrent);
            if (!this.isAir(blockCurrent) && !blockstateCurrent.method_26164(class_3481.field_15503)) continue;
            return distanceToAirWater;
        }
        return 128;
    }

    protected boolean maybeDecayUnder(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        class_2338 underPos = pos.method_10074();
        class_2248 underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        class_2248 decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == class_2246.field_10124) {
            return false;
        }
        class_243 velocity = this.getFlowVelocity(world, state, pos);
        if (Math.abs(velocity.field_1352) < 0.8 && Math.abs(velocity.field_1350) < 0.8) {
            return false;
        }
        class_2338 flowPos = underPos.method_10081(new class_2382((int)Math.round(velocity.field_1352), 0, (int)Math.round(velocity.field_1350)));
        class_2248 flowBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.method_8501(underPos, decayTo.method_9564());
        return true;
    }

    protected boolean isCobbleStone(class_2248 block) {
        return block == class_2246.field_10445 || block == class_2246.field_10625 || block == class_2246.field_10596 || block == class_2246.field_10625;
    }

    protected boolean isStoneBricks(class_2248 block) {
        return block == class_2246.field_10056 || block == class_2246.field_10252 || block == class_2246.field_10392 || block == class_2246.field_10252;
    }

    protected boolean maybeAddMoss(class_1937 world, class_2338 pos, class_5819 rand) {
        List<class_2382> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<class_2382> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            class_2382 dir = iterator.next();
            class_2338 sidePos = pos.method_10081(dir);
            class_2248 sideBlock = this.getBlock(world, sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            class_2248 mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == class_2246.field_10124) {
                return false;
            }
            world.method_8501(sidePos, mossBlock.method_9564());
            return true;
        }
        return false;
    }

    private class wallBreakOption {
        class_2382 dir;
        Integer distance;

        private wallBreakOption() {
        }
    }
}

