/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class Tasks {
    private static final Vec3i VECTOR_DOWN = new Vec3i(0, -1, 0);
    private static final Vec3i VECTOR_UP = new Vec3i(0, 1, 0);
    private static final Vec3i VECTOR_NORTH = new Vec3i(0, 0, -1);
    private static final Vec3i VECTOR_NORTH_EAST = new Vec3i(1, 0, -1);
    private static final Vec3i VECTOR_EAST = new Vec3i(1, 0, 0);
    private static final Vec3i VECTOR_SOUTH_EAST = new Vec3i(1, 0, 1);
    private static final Vec3i VECTOR_SOUTH = new Vec3i(0, 0, 1);
    private static final Vec3i VECTOR_SOUTH_WEST = new Vec3i(-1, 0, 1);
    private static final Vec3i VECTOR_WEST = new Vec3i(-1, 0, 0);
    private static final Vec3i VECTOR_NORTH_WEST = new Vec3i(-1, 0, -1);
    private static final List<Vec3i> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<Vec3i> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<Vec3i> posEightAroundUp = Arrays.asList(new Vec3i(1, 1, 1), new Vec3i(1, 1, 0), new Vec3i(1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);
    public final int AIR_WATER_NOT_FOUND = 128;

    public void run(Level world, BlockState state, BlockPos pos, RandomSource rand) {
        Integer level = (Integer)state.m_61143_((Property)LiquidBlock.f_54688_);
        this.maybeSourceBreak(world, state, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(world, state, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(world, state, pos, rand, level);
        this.maybeDecayUnder(world, state, pos, rand, level);
    }

    public Vec3 getFlowVelocity(Level world, BlockPos pos, BlockState state) {
        FluidState fluidState = state.m_60819_();
        return fluidState.m_76179_((BlockGetter)world, pos);
    }

    public Boolean isFluidBlock(Block block) {
        return block instanceof LiquidBlock;
    }

    public Block getBlock(Level world, BlockPos pos) {
        BlockState bs = world.m_8055_(pos);
        return bs.m_60734_();
    }

    protected boolean maybeErodeEdge(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        BlockPos underPos = pos.m_7495_();
        Block underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return false;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return false;
        }
        Block decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != Blocks.f_50016_) {
            world.m_46597_(underPos, decayBlock.m_49966_());
            return true;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.m_46597_(underPos, (BlockState)Blocks.f_49990_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)underBlocklevel));
        if (state.m_61143_((Property)LiquidBlock.f_54688_) == FluidLevel.SOURCE) {
            return false;
        }
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        Integer upDeleteCount = 0;
        BlockPos posUp = pos.m_7494_();
        while (this.isFluidBlock(this.getBlock(world, posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            upDeleteCount = upDeleteCount + 1;
            if (upDeleteCount > 3 || world.m_8055_(posUp).m_61143_((Property)LiquidBlock.f_54688_) == FluidLevel.SOURCE) break;
            world.m_46597_(posUp, Blocks.f_50016_.m_49966_());
            posUp = posUp.m_7494_();
        }
        return true;
    }

    protected boolean isEdge(Level world, BlockPos pos) {
        List<BlockPos> listSidePos = Arrays.asList(pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_());
        for (BlockPos sidePos : listSidePos) {
            BlockPos underPos = sidePos.m_7495_();
            Block underBlock = this.getBlock(world, underPos);
            if (!this.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Vec3i dirTurnLeft(Vec3i in) {
        return in.m_7724_(VECTOR_DOWN);
    }

    protected Vec3i dirTurnRight(Vec3i in) {
        return in.m_7724_(VECTOR_UP);
    }

    protected boolean treeInColumn(Level world, BlockPos pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        BlockPos currentPos = pos.m_7494_();
        while (count < MAX_UP) {
            BlockState bs = world.m_8055_(currentPos);
            Block currentBlock = bs.m_60734_();
            if (bs.m_204336_(BlockTags.f_13106_)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            count = count + 1;
            currentPos = currentPos.m_7494_();
        }
        return false;
    }

    protected boolean maybeFlowingWall(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        Vec3i dirForward;
        Vec3i shortestDir;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.f_82479_) < 0.8 && Math.abs(velocity.f_82481_) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if ((shortestDir = this.findShortestDirectionToAirOrWater(world, pos, level, dirForward = new Vec3i((int)Math.round(velocity.f_82479_), (int)velocity.f_82480_ + Flow7Adjust, (int)Math.round(velocity.f_82481_)))) == null) {
            return false;
        }
        BlockPos flowPos = pos.m_121955_(shortestDir);
        Block wallBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.m_46597_(flowPos, Blocks.f_50016_.m_49966_());
        return true;
    }

    protected Vec3i findShortestDirectionToAirOrWater(Level world, BlockPos pos, Integer level, Vec3i dirForward) {
        Integer dist;
        BlockPos posForward = pos.m_121955_(dirForward);
        Block blockForward = this.getBlock(world, posForward);
        if (this.isAir(blockForward) || blockForward == Blocks.f_49990_ || blockForward == Blocks.f_49991_) {
            return null;
        }
        Vec3i dirLeft = this.dirTurnLeft(dirForward);
        Vec3i dirRight = this.dirTurnRight(dirForward);
        BlockPos posLeft = pos.m_121955_(dirLeft);
        BlockPos posRight = pos.m_121955_(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(this.getBlock(world, posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(this.getBlock(world, posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return null;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            options.add(new wallBreakOption(dirForward, dist));
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            options.add(new wallBreakOption(dirLeft, dist));
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            options.add(new wallBreakOption(dirRight, dist));
        }
        if (options.size() == 0) {
            return null;
        }
        Integer shortestDistance = 128;
        Vec3i shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        return shortestDir;
    }

    protected msb maybeSourceBreak(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return msb.NOT_SOURCE;
        }
        if (pos.m_123342_() < world.m_5736_()) {
            return msb.BELOW_SEA_LEVEL;
        }
        Block upBlock = world.m_8055_(pos.m_7494_()).m_60734_();
        if (!this.isAir(upBlock)) {
            return msb.NOT_SURFACE_WATER;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (velocity.m_82553_() > 0.0) {
            return msb.ALREADY_FLOWING;
        }
        List<Vec3i> listDirection = Arrays.asList(VECTOR_NORTH, VECTOR_SOUTH, VECTOR_EAST, VECTOR_WEST);
        for (Vec3i dir : listDirection) {
            BlockPos sidePos = pos.m_121955_(dir);
            Block sideBlock = this.getBlock(world, sidePos);
            if (sideBlock == Blocks.f_49990_ || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock)) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return msb.MAYBE_NOT_ERODE;
            }
            Integer dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level);
            if (dist == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                Vec3i waterDirection = new Vec3i(-dir.m_123341_() * waterMultipler, dir.m_123342_(), -dir.m_123343_() * waterMultipler);
                BlockPos maybeWaterPos = pos.m_121955_(waterDirection);
                BlockState maybeWaterState = world.m_8055_(maybeWaterPos);
                if (maybeWaterState.m_60734_() != Blocks.f_49990_) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            world.m_46597_(sidePos, Blocks.f_50016_.m_49966_());
            return msb.SUCCESS;
        }
        return msb.NOT_FOUND;
    }

    private boolean isAir(Block block) {
        return block == Blocks.f_50016_ || block == Blocks.f_50627_;
    }

    protected Integer distanceToAirWaterInFlowPath(Level world, BlockPos pos, Vec3i dir, Integer level) {
        Block blockCurrent;
        BlockState blockstateCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        BlockPos posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockstateCurrent = world.m_8055_(posCurrent = posCurrent.m_121955_(dir));
            blockCurrent = blockstateCurrent.m_60734_();
            if (this.isAir(blockCurrent) || blockstateCurrent.m_204336_(BlockTags.f_13035_) || blockCurrent == Blocks.f_49990_) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.m_7495_();
        flowDistanceRemaining = 8;
        while (flowDistanceRemaining > 0) {
            blockstateCurrent = world.m_8055_(posCurrent);
            blockCurrent = blockstateCurrent.m_60734_();
            if (this.isAir(blockCurrent) || blockstateCurrent.m_204336_(BlockTags.f_13035_) || blockCurrent == Blocks.f_49990_) {
                return distanceToAirWater;
            }
            if (!ErodableBlocks.canErode(blockCurrent)) {
                return 128;
            }
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            posCurrent = posCurrent.m_121955_(dir);
        }
        return 128;
    }

    protected boolean maybeDecayUnder(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        BlockPos underPos = pos.m_7495_();
        Block underBlock = this.getBlock(world, underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        Block decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == Blocks.f_50016_) {
            return false;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.f_82479_) < 0.8 && Math.abs(velocity.f_82481_) < 0.8) {
            return false;
        }
        BlockPos flowPos = underPos.m_121955_(new Vec3i((int)Math.round(velocity.f_82479_), 0, (int)Math.round(velocity.f_82481_)));
        Block flowBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.m_46597_(underPos, decayTo.m_49966_());
        return true;
    }

    protected boolean isCobbleStone(Block block) {
        return block == Blocks.f_50652_ || block == Blocks.f_50274_ || block == Blocks.f_50157_ || block == Blocks.f_50274_;
    }

    protected boolean isStoneBricks(Block block) {
        return block == Blocks.f_50222_ || block == Blocks.f_50609_ || block == Blocks.f_50194_ || block == Blocks.f_50609_;
    }

    protected boolean maybeAddMoss(Level world, BlockPos pos, RandomSource rand) {
        List<Vec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<Vec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            Vec3i dir = iterator.next();
            BlockPos sidePos = pos.m_121955_(dir);
            Block sideBlock = this.getBlock(world, sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            Block mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == Blocks.f_50016_) {
                return false;
            }
            world.m_46597_(sidePos, mossBlock.m_49966_());
            return true;
        }
        return false;
    }

    public static enum msb {
        NOT_SOURCE,
        BELOW_SEA_LEVEL,
        NOT_SURFACE_WATER,
        ALREADY_FLOWING,
        MAYBE_NOT_ERODE,
        SUCCESS,
        NOT_FOUND;

    }

    private class wallBreakOption {
        Vec3i dir;
        Integer distance;

        public wallBreakOption(Vec3i dir, Integer distance) {
            this.dir = dir;
            this.distance = distance;
        }
    }
}

