/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.DefaultErosionConfig;
import com._13rac1.erosion.common.IErosionConfig;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ErodableBlocks {
    public static IErosionConfig Config = new DefaultErosionConfig();
    private static final Integer MAX_RESIST_ODDS = 0;
    private static final Integer SOURCE_BREAK_RESIST_ODDS = 8;
    private static final Integer LEAF_RESIST_ODDS = 1;
    private static final Integer SAND_RESIST_ODDS = 1;
    private static final Integer WOOL_RESIST_ODDS = 1;
    private static final Integer GRAVEL_RESIST_ODDS = 2;
    private static final Integer CLAY_RESIST_ODDS = 5;
    private static final Integer DIRT_RESIST_ODDS = 4;
    private static final Integer GRASS_RESIST_ODDS = 6;
    private static final Integer COBBLE_RESIST_ODDS = 20;
    private static final Integer BRICK_RESIST_ODDS = 25;
    private static final Integer DECAY_ALWAYS_ODDS = 0;
    private static final Integer DECAY_NEVER_ODDS = 100;
    private static final Integer DECAY_TO_AIR_ODDS = 0;
    private static final Integer DECAY_TO_SAND_ODDS = 1;
    private static final Integer DECAY_TO_GRAVEL_ODDS = 0;
    private static final Integer DECAY_TO_CLAY_ODDS = 20;
    private static final Integer DECAY_TO_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_COARSE_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_MOSSY_COBBLE_ODDS = 0;
    private static final Integer DECAY_TO_MOSSY_BRICKS_ODDS = 1;
    private static HashMap<Block, Integer> decayables;
    private static HashMap<Block, Erodable> erodables;

    private static HashMap<Block, Integer> getDecayables() {
        if (decayables == null) {
            decayables = new HashMap();
            decayables.put(Blocks.f_50016_, DECAY_TO_AIR_ODDS);
            decayables.put(Blocks.f_50129_, DECAY_TO_CLAY_ODDS);
            decayables.put(Blocks.f_49992_, DECAY_TO_SAND_ODDS);
            decayables.put(Blocks.f_49994_, DECAY_TO_GRAVEL_ODDS);
            decayables.put(Blocks.f_220864_, DECAY_TO_DIRT_ODDS);
            decayables.put(Blocks.f_50493_, DECAY_TO_DIRT_ODDS);
            decayables.put(Blocks.f_50546_, DECAY_TO_COARSE_DIRT_ODDS);
            decayables.put(Blocks.f_50079_, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.f_50647_, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.f_50633_, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.f_50275_, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.f_50223_, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.f_50645_, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.f_50631_, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.f_50607_, DECAY_TO_MOSSY_BRICKS_ODDS);
        }
        return decayables;
    }

    private static HashMap<Block, Erodable> getErodables() {
        if (erodables == null) {
            erodables = new HashMap();
            erodables.put(Blocks.f_50129_, new Erodable(CLAY_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_49993_, new Erodable(SAND_RESIST_ODDS, Blocks.f_50129_));
            erodables.put(Blocks.f_49992_, new Erodable(SAND_RESIST_ODDS, Blocks.f_50129_));
            erodables.put(Blocks.f_49994_, new Erodable(GRAVEL_RESIST_ODDS, Blocks.f_49992_));
            erodables.put(Blocks.f_220864_, new Erodable(DIRT_RESIST_ODDS, Blocks.f_49994_));
            erodables.put(Blocks.f_50546_, new Erodable(DIRT_RESIST_ODDS, Blocks.f_220864_));
            if (Config.GetErodeFarmLand().booleanValue()) {
                erodables.put(Blocks.f_50093_, new Erodable(DIRT_RESIST_ODDS, Blocks.f_50546_));
            }
            erodables.put(Blocks.f_50493_, new Erodable(DIRT_RESIST_ODDS, Blocks.f_50546_));
            erodables.put(Blocks.f_50599_, new Erodable(DIRT_RESIST_ODDS, Blocks.f_50546_));
            erodables.put(Blocks.f_50440_, new Erodable(GRASS_RESIST_ODDS, Blocks.f_50493_));
            erodables.put(Blocks.f_303709_, new Erodable(GRASS_RESIST_ODDS, Blocks.f_50493_));
            erodables.put(Blocks.f_152481_, new Erodable(GRASS_RESIST_ODDS, Blocks.f_303709_));
            erodables.put(Blocks.f_50079_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_49994_));
            erodables.put(Blocks.f_220844_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_220864_));
            erodables.put(Blocks.f_220849_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_220845_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_220854_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_50647_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_50633_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_50275_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50016_));
            erodables.put(Blocks.f_50652_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50079_));
            erodables.put(Blocks.f_50409_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50647_));
            erodables.put(Blocks.f_50157_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50633_));
            erodables.put(Blocks.f_50274_, new Erodable(COBBLE_RESIST_ODDS, Blocks.f_50275_));
            erodables.put(Blocks.f_50224_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50652_));
            erodables.put(Blocks.f_50223_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50224_));
            erodables.put(Blocks.f_50645_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50647_));
            erodables.put(Blocks.f_50631_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50633_));
            erodables.put(Blocks.f_50607_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50275_));
            erodables.put(Blocks.f_50222_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50223_));
            erodables.put(Blocks.f_50411_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50645_));
            erodables.put(Blocks.f_50194_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50631_));
            erodables.put(Blocks.f_50609_, new Erodable(BRICK_RESIST_ODDS, Blocks.f_50607_));
            erodables.forEach((block, erodable) -> {
                Erodable current = erodable;
                while (current.decayBlock != Blocks.f_50016_) {
                    erodable.decayList.add(current.decayBlock);
                    current = erodables.get(current.decayBlock);
                }
            });
        }
        return erodables;
    }

    public static Integer getResistance(Block block) {
        if (ErodableBlocks.getErodables().containsKey(block)) {
            return ErodableBlocks.getErodables().get((Object)block).resistanceOdds;
        }
        BlockState bs = block.m_49966_();
        if (bs.m_204336_(BlockTags.f_13035_)) {
            return LEAF_RESIST_ODDS;
        }
        if (bs.m_204336_(BlockTags.f_13029_)) {
            return SAND_RESIST_ODDS;
        }
        if (bs.m_204336_(BlockTags.f_13089_)) {
            return WOOL_RESIST_ODDS;
        }
        return MAX_RESIST_ODDS;
    }

    public static boolean canErode(Block block) {
        return ErodableBlocks.getResistance(block) != MAX_RESIST_ODDS;
    }

    public static boolean maybeErode(RandomSource rand, Block block) {
        return rand.m_188503_(ErodableBlocks.getResistance(block).intValue()) == 0;
    }

    public static Block maybeDecay(RandomSource rand, Block block) {
        Integer odds = DECAY_NEVER_ODDS;
        Block decayToBlock = Blocks.f_50016_;
        if (ErodableBlocks.getErodables().containsKey(block)) {
            decayToBlock = ErodableBlocks.getErodables().get((Object)block).decayBlock;
        }
        if (!ErodableBlocks.getDecayables().containsKey(decayToBlock)) {
            return Blocks.f_50016_;
        }
        odds = ErodableBlocks.getDecayables().get(decayToBlock);
        if (odds == DECAY_NEVER_ODDS) {
            return Blocks.f_50016_;
        }
        if (odds == DECAY_ALWAYS_ODDS) {
            return decayToBlock;
        }
        if (rand.m_188503_(odds.intValue()) == 0) {
            return decayToBlock;
        }
        return Blocks.f_50016_;
    }

    public static Block decayTo(Block block) {
        HashMap<Block, Erodable> erodables = ErodableBlocks.getErodables();
        if (erodables.containsKey(block)) {
            return erodables.get((Object)block).decayBlock;
        }
        return Blocks.f_50016_;
    }

    public static boolean canSourceBreak(Block block) {
        return ErodableBlocks.getResistance(block) < SOURCE_BREAK_RESIST_ODDS;
    }

    public static ArrayList<Block> getDecayList(Block block) {
        return ErodableBlocks.getErodables().get((Object)block).decayList;
    }

    static class Erodable {
        Integer resistanceOdds;
        Block decayBlock;
        ArrayList<Block> decayList;

        Erodable(Integer resistanceOdds, Block decayBlock) {
            this.resistanceOdds = resistanceOdds;
            this.decayBlock = decayBlock;
            this.decayList = new ArrayList();
        }
    }
}

