/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.DefaultErosionConfig;
import com._13rac1.erosion.common.IErosionConfig;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ErodableBlocks {
    public static IErosionConfig Config = new DefaultErosionConfig();
    private static final Integer MAX_RESIST_ODDS = 0;
    private static final Integer SOURCE_BREAK_RESIST_ODDS = 8;
    private static final Integer LEAF_RESIST_ODDS = 1;
    private static final Integer SAND_RESIST_ODDS = 1;
    private static final Integer WOOL_RESIST_ODDS = 1;
    private static final Integer GRAVEL_RESIST_ODDS = 2;
    private static final Integer CLAY_RESIST_ODDS = 5;
    private static final Integer DIRT_RESIST_ODDS = 4;
    private static final Integer GRASS_RESIST_ODDS = 6;
    private static final Integer COBBLE_RESIST_ODDS = 20;
    private static final Integer BRICK_RESIST_ODDS = 25;
    private static final Integer DECAY_ALWAYS_ODDS = 0;
    private static final Integer DECAY_NEVER_ODDS = 100;
    private static final Integer DECAY_TO_AIR_ODDS = 0;
    private static final Integer DECAY_TO_SAND_ODDS = 1;
    private static final Integer DECAY_TO_GRAVEL_ODDS = 0;
    private static final Integer DECAY_TO_CLAY_ODDS = 20;
    private static final Integer DECAY_TO_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_COARSE_DIRT_ODDS = 1;
    private static final Integer DECAY_TO_MOSSY_COBBLE_ODDS = 0;
    private static final Integer DECAY_TO_MOSSY_BRICKS_ODDS = 1;
    private static HashMap<Block, Integer> decayables;
    private static HashMap<Block, Erodable> erodables;

    private static HashMap<Block, Integer> getDecayables() {
        if (decayables == null) {
            decayables = new HashMap();
            decayables.put(Blocks.AIR, DECAY_TO_AIR_ODDS);
            decayables.put(Blocks.CLAY, DECAY_TO_CLAY_ODDS);
            decayables.put(Blocks.SAND, DECAY_TO_SAND_ODDS);
            decayables.put(Blocks.GRAVEL, DECAY_TO_GRAVEL_ODDS);
            decayables.put(Blocks.MUD, DECAY_TO_DIRT_ODDS);
            decayables.put(Blocks.DIRT, DECAY_TO_DIRT_ODDS);
            decayables.put(Blocks.COARSE_DIRT, DECAY_TO_COARSE_DIRT_ODDS);
            decayables.put(Blocks.MOSSY_COBBLESTONE, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.MOSSY_COBBLESTONE_SLAB, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.MOSSY_COBBLESTONE_STAIRS, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.MOSSY_COBBLESTONE_WALL, DECAY_TO_MOSSY_COBBLE_ODDS);
            decayables.put(Blocks.MOSSY_STONE_BRICKS, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.MOSSY_STONE_BRICK_SLAB, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.MOSSY_STONE_BRICK_STAIRS, DECAY_TO_MOSSY_BRICKS_ODDS);
            decayables.put(Blocks.MOSSY_STONE_BRICK_WALL, DECAY_TO_MOSSY_BRICKS_ODDS);
        }
        return decayables;
    }

    private static HashMap<Block, Erodable> getErodables() {
        if (erodables == null) {
            erodables = new HashMap();
            erodables.put(Blocks.CLAY, new Erodable(CLAY_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.RED_SAND, new Erodable(SAND_RESIST_ODDS, Blocks.CLAY));
            erodables.put(Blocks.SAND, new Erodable(SAND_RESIST_ODDS, Blocks.CLAY));
            erodables.put(Blocks.GRAVEL, new Erodable(GRAVEL_RESIST_ODDS, Blocks.SAND));
            erodables.put(Blocks.MUD, new Erodable(DIRT_RESIST_ODDS, Blocks.GRAVEL));
            erodables.put(Blocks.COARSE_DIRT, new Erodable(DIRT_RESIST_ODDS, Blocks.MUD));
            if (Config.GetErodeFarmLand().booleanValue()) {
                erodables.put(Blocks.FARMLAND, new Erodable(DIRT_RESIST_ODDS, Blocks.COARSE_DIRT));
            }
            erodables.put(Blocks.DIRT, new Erodable(DIRT_RESIST_ODDS, Blocks.COARSE_DIRT));
            erodables.put(Blocks.PODZOL, new Erodable(DIRT_RESIST_ODDS, Blocks.COARSE_DIRT));
            erodables.put(Blocks.GRASS_BLOCK, new Erodable(GRASS_RESIST_ODDS, Blocks.DIRT));
            erodables.put(Blocks.SHORT_GRASS, new Erodable(GRASS_RESIST_ODDS, Blocks.DIRT));
            erodables.put(Blocks.DIRT_PATH, new Erodable(GRASS_RESIST_ODDS, Blocks.SHORT_GRASS));
            erodables.put(Blocks.MOSSY_COBBLESTONE, new Erodable(COBBLE_RESIST_ODDS, Blocks.GRAVEL));
            erodables.put(Blocks.MUD_BRICKS, new Erodable(COBBLE_RESIST_ODDS, Blocks.MUD));
            erodables.put(Blocks.MUD_BRICK_SLAB, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.MUD_BRICK_STAIRS, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.MUD_BRICK_WALL, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.MOSSY_COBBLESTONE_SLAB, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.MOSSY_COBBLESTONE_STAIRS, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.MOSSY_COBBLESTONE_WALL, new Erodable(COBBLE_RESIST_ODDS, Blocks.AIR));
            erodables.put(Blocks.COBBLESTONE, new Erodable(COBBLE_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE));
            erodables.put(Blocks.COBBLESTONE_SLAB, new Erodable(COBBLE_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_SLAB));
            erodables.put(Blocks.COBBLESTONE_STAIRS, new Erodable(COBBLE_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_STAIRS));
            erodables.put(Blocks.COBBLESTONE_WALL, new Erodable(COBBLE_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_WALL));
            erodables.put(Blocks.CRACKED_STONE_BRICKS, new Erodable(BRICK_RESIST_ODDS, Blocks.COBBLESTONE));
            erodables.put(Blocks.MOSSY_STONE_BRICKS, new Erodable(BRICK_RESIST_ODDS, Blocks.CRACKED_STONE_BRICKS));
            erodables.put(Blocks.MOSSY_STONE_BRICK_SLAB, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_SLAB));
            erodables.put(Blocks.MOSSY_STONE_BRICK_STAIRS, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_STAIRS));
            erodables.put(Blocks.MOSSY_STONE_BRICK_WALL, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_COBBLESTONE_WALL));
            erodables.put(Blocks.STONE_BRICKS, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_STONE_BRICKS));
            erodables.put(Blocks.STONE_BRICK_SLAB, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_STONE_BRICK_SLAB));
            erodables.put(Blocks.STONE_BRICK_STAIRS, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_STONE_BRICK_STAIRS));
            erodables.put(Blocks.STONE_BRICK_WALL, new Erodable(BRICK_RESIST_ODDS, Blocks.MOSSY_STONE_BRICK_WALL));
            erodables.forEach((block, erodable) -> {
                Erodable current = erodable;
                while (current.decayBlock != Blocks.AIR) {
                    erodable.decayList.add(current.decayBlock);
                    current = erodables.get(current.decayBlock);
                }
            });
        }
        return erodables;
    }

    public static Integer getResistance(Block block) {
        if (ErodableBlocks.getErodables().containsKey(block)) {
            return ErodableBlocks.getErodables().get((Object)block).resistanceOdds;
        }
        BlockState bs = block.defaultBlockState();
        if (bs.is(BlockTags.LEAVES)) {
            return LEAF_RESIST_ODDS;
        }
        if (bs.is(BlockTags.SAND)) {
            return SAND_RESIST_ODDS;
        }
        if (bs.is(BlockTags.WOOL)) {
            return WOOL_RESIST_ODDS;
        }
        return MAX_RESIST_ODDS;
    }

    public static boolean canErode(Block block) {
        return ErodableBlocks.getResistance(block) != MAX_RESIST_ODDS;
    }

    public static boolean maybeErode(RandomSource rand, Block block) {
        return rand.nextInt(ErodableBlocks.getResistance(block).intValue()) == 0;
    }

    public static Block maybeDecay(RandomSource rand, Block block) {
        Integer odds = DECAY_NEVER_ODDS;
        Block decayToBlock = Blocks.AIR;
        if (ErodableBlocks.getErodables().containsKey(block)) {
            decayToBlock = ErodableBlocks.getErodables().get((Object)block).decayBlock;
        }
        if (!ErodableBlocks.getDecayables().containsKey(decayToBlock)) {
            return Blocks.AIR;
        }
        odds = ErodableBlocks.getDecayables().get(decayToBlock);
        if (odds == DECAY_NEVER_ODDS) {
            return Blocks.AIR;
        }
        if (odds == DECAY_ALWAYS_ODDS) {
            return decayToBlock;
        }
        if (rand.nextInt(odds.intValue()) == 0) {
            return decayToBlock;
        }
        return Blocks.AIR;
    }

    public static Block decayTo(Block block) {
        HashMap<Block, Erodable> erodables = ErodableBlocks.getErodables();
        if (erodables.containsKey(block)) {
            return erodables.get((Object)block).decayBlock;
        }
        return Blocks.AIR;
    }

    public static boolean canSourceBreak(Block block) {
        return ErodableBlocks.getResistance(block) < SOURCE_BREAK_RESIST_ODDS;
    }

    public static ArrayList<Block> getDecayList(Block block) {
        return ErodableBlocks.getErodables().get((Object)block).decayList;
    }

    static class Erodable {
        Integer resistanceOdds;
        Block decayBlock;
        ArrayList<Block> decayList;

        Erodable(Integer resistanceOdds, Block decayBlock) {
            this.resistanceOdds = resistanceOdds;
            this.decayBlock = decayBlock;
            this.decayList = new ArrayList();
        }
    }
}

