/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.FluidLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tasks {
    private static final Logger LOGGER = LogManager.getFormatterLogger(Tasks.class);
    private static final Vec3i VECTOR_DOWN = new Vec3i(0, -1, 0);
    private static final Vec3i VECTOR_UP = new Vec3i(0, 1, 0);
    private static final Vec3i VECTOR_NORTH = new Vec3i(0, 0, -1);
    private static final Vec3i VECTOR_NORTH_EAST = new Vec3i(1, 0, -1);
    private static final Vec3i VECTOR_EAST = new Vec3i(1, 0, 0);
    private static final Vec3i VECTOR_SOUTH_EAST = new Vec3i(1, 0, 1);
    private static final Vec3i VECTOR_SOUTH = new Vec3i(0, 0, 1);
    private static final Vec3i VECTOR_SOUTH_WEST = new Vec3i(-1, 0, 1);
    private static final Vec3i VECTOR_WEST = new Vec3i(-1, 0, 0);
    private static final Vec3i VECTOR_NORTH_WEST = new Vec3i(-1, 0, -1);
    private static final List<Vec3i> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<Vec3i> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<Vec3i> posEightAroundUp = Arrays.asList(new Vec3i(1, 1, 1), new Vec3i(1, 1, 0), new Vec3i(1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);
    public final int AIR_WATER_NOT_FOUND = 128;

    public void run(Level world, BlockState state, BlockPos pos, RandomSource rand) {
        Integer level = (Integer)state.getValue((Property)LiquidBlock.LEVEL);
        this.maybeSourceBreak(world, state, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(world, state, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(world, state, pos, rand, level);
        this.maybeDecayUnder(world, state, pos, rand, level);
    }

    public Vec3 getFlowVelocity(Level world, BlockPos pos, BlockState state) {
        FluidState fluidState = state.getFluidState();
        return fluidState.getFlow((BlockGetter)world, pos);
    }

    public Boolean isFluidBlock(Block block) {
        return block instanceof LiquidBlock;
    }

    public Block getBlock(Level world, BlockPos pos) {
        BlockState bs = world.getBlockState(pos);
        return bs.getBlock();
    }

    protected boolean maybeErodeEdge(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        BlockPos underPos = pos.below();
        BlockState underState = world.getBlockState(underPos);
        Block underBlock = underState.getBlock();
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return false;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return false;
        }
        Block decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != Blocks.AIR) {
            BlockState newState = decayBlock.defaultBlockState();
            Boolean propertiesCopied = false;
            if (this.isCobbleStone(underBlock) || this.isStoneBrick(underBlock) || this.isMossyStoneBrick(underBlock)) {
                newState = this.copyProperties(underState, newState);
                propertiesCopied = true;
            }
            world.setBlockAndUpdate(underPos, newState);
            LOGGER.debug("ErodeEdge '%s' => '%s', copied properties: %s", (Object)underBlock, (Object)decayBlock, (Object)propertiesCopied);
            return true;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        BlockState water = (BlockState)Blocks.WATER.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)underBlocklevel);
        world.setBlockAndUpdate(underPos, water);
        LOGGER.debug("ErodeEdge '%s' => water", (Object)underBlock);
        if (state.getValue((Property)LiquidBlock.LEVEL) == FluidLevel.SOURCE) {
            return false;
        }
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        Integer upDeleteCount = 0;
        BlockPos posUp = pos.above();
        while (this.isFluidBlock(this.getBlock(world, posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            upDeleteCount = upDeleteCount + 1;
            if (upDeleteCount > 3 || world.getBlockState(posUp).getValue((Property)LiquidBlock.LEVEL) == FluidLevel.SOURCE) break;
            world.setBlockAndUpdate(posUp, Blocks.AIR.defaultBlockState());
            posUp = posUp.above();
        }
        return true;
    }

    protected boolean isEdge(Level world, BlockPos pos) {
        List<BlockPos> listSidePos = Arrays.asList(pos.north(), pos.south(), pos.east(), pos.west());
        for (BlockPos sidePos : listSidePos) {
            BlockPos underPos = sidePos.below();
            Block underBlock = this.getBlock(world, underPos);
            if (!this.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Vec3i dirTurnLeft(Vec3i in) {
        return in.cross(VECTOR_DOWN);
    }

    protected Vec3i dirTurnRight(Vec3i in) {
        return in.cross(VECTOR_UP);
    }

    protected boolean treeInColumn(Level world, BlockPos pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        BlockPos currentPos = pos.above();
        while (count < MAX_UP) {
            BlockState bs = world.getBlockState(currentPos);
            Block currentBlock = bs.getBlock();
            if (bs.is(BlockTags.LOGS)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            count = count + 1;
            currentPos = currentPos.above();
        }
        return false;
    }

    protected boolean maybeFlowingWall(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        Vec3i dirForward;
        Vec3i shortestDir;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.x) < 0.8 && Math.abs(velocity.z) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if ((shortestDir = this.findShortestDirectionToAirOrWater(world, pos, level, dirForward = new Vec3i((int)Math.round(velocity.x), (int)velocity.y + Flow7Adjust, (int)Math.round(velocity.z)))) == null) {
            return false;
        }
        BlockPos flowPos = pos.offset(shortestDir);
        Block wallBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.setBlockAndUpdate(flowPos, Blocks.AIR.defaultBlockState());
        return true;
    }

    protected Vec3i findShortestDirectionToAirOrWater(Level world, BlockPos pos, Integer level, Vec3i dirForward) {
        Integer dist;
        BlockPos posForward = pos.offset(dirForward);
        Block blockForward = this.getBlock(world, posForward);
        if (this.isAir(blockForward) || blockForward == Blocks.WATER || blockForward == Blocks.LAVA) {
            return null;
        }
        Vec3i dirLeft = this.dirTurnLeft(dirForward);
        Vec3i dirRight = this.dirTurnRight(dirForward);
        BlockPos posLeft = pos.offset(dirLeft);
        BlockPos posRight = pos.offset(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(this.getBlock(world, posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(this.getBlock(world, posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return null;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            options.add(new wallBreakOption(dirForward, dist));
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            options.add(new wallBreakOption(dirLeft, dist));
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            options.add(new wallBreakOption(dirRight, dist));
        }
        if (options.size() == 0) {
            return null;
        }
        Integer shortestDistance = 128;
        Vec3i shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        return shortestDir;
    }

    protected msb maybeSourceBreak(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return msb.NOT_SOURCE;
        }
        if (pos.getY() < world.getSeaLevel()) {
            return msb.BELOW_SEA_LEVEL;
        }
        Block upBlock = world.getBlockState(pos.above()).getBlock();
        if (!this.isAir(upBlock)) {
            return msb.NOT_SURFACE_WATER;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (velocity.length() > 0.0) {
            return msb.ALREADY_FLOWING;
        }
        List<Vec3i> listDirection = Arrays.asList(VECTOR_NORTH, VECTOR_SOUTH, VECTOR_EAST, VECTOR_WEST);
        for (Vec3i dir : listDirection) {
            BlockPos sidePos = pos.offset(dir);
            Block sideBlock = this.getBlock(world, sidePos);
            if (sideBlock == Blocks.WATER || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock)) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return msb.MAYBE_NOT_ERODE;
            }
            Integer dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level);
            if (dist == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                Vec3i waterDirection = new Vec3i(-dir.getX() * waterMultipler, dir.getY(), -dir.getZ() * waterMultipler);
                BlockPos maybeWaterPos = pos.offset(waterDirection);
                BlockState maybeWaterState = world.getBlockState(maybeWaterPos);
                if (maybeWaterState.getBlock() != Blocks.WATER) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            world.setBlockAndUpdate(sidePos, Blocks.AIR.defaultBlockState());
            return msb.SUCCESS;
        }
        return msb.NOT_FOUND;
    }

    private boolean isAir(Block block) {
        return block == Blocks.AIR || block == Blocks.CAVE_AIR;
    }

    protected Integer distanceToAirWaterInFlowPath(Level world, BlockPos pos, Vec3i dir, Integer level) {
        Block blockCurrent;
        BlockState blockstateCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        BlockPos posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockstateCurrent = world.getBlockState(posCurrent = posCurrent.offset(dir));
            blockCurrent = blockstateCurrent.getBlock();
            if (this.isAir(blockCurrent) || blockstateCurrent.is(BlockTags.LEAVES) || blockCurrent == Blocks.WATER) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.below();
        flowDistanceRemaining = 8;
        while (flowDistanceRemaining > 0) {
            blockstateCurrent = world.getBlockState(posCurrent);
            blockCurrent = blockstateCurrent.getBlock();
            if (this.isAir(blockCurrent) || blockstateCurrent.is(BlockTags.LEAVES) || blockCurrent == Blocks.WATER) {
                return distanceToAirWater;
            }
            if (!ErodableBlocks.canErode(blockCurrent)) {
                return 128;
            }
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            posCurrent = posCurrent.offset(dir);
        }
        return 128;
    }

    protected boolean maybeDecayUnder(Level world, BlockState state, BlockPos pos, RandomSource rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        BlockPos underPos = pos.below();
        BlockState underState = world.getBlockState(underPos);
        Block underBlock = underState.getBlock();
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        Block decayBlock = ErodableBlocks.decayTo(underBlock);
        if (decayBlock == Blocks.AIR) {
            return false;
        }
        Vec3 velocity = this.getFlowVelocity(world, pos, state);
        if (Math.abs(velocity.x) < 0.8 && Math.abs(velocity.z) < 0.8) {
            return false;
        }
        BlockPos flowPos = underPos.offset(new Vec3i((int)Math.round(velocity.x), 0, (int)Math.round(velocity.z)));
        Block flowBlock = this.getBlock(world, flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        BlockState newState = decayBlock.defaultBlockState();
        Boolean propertiesCopied = false;
        if (this.isCobbleStone(underBlock) || this.isStoneBrick(underBlock) || this.isMossyStoneBrick(underBlock)) {
            newState = this.copyProperties(underState, newState);
            propertiesCopied = true;
        }
        LOGGER.debug("DecayUnder '%s' => '%s', copied properties: %s", (Object)underBlock, (Object)decayBlock, (Object)propertiesCopied);
        world.setBlockAndUpdate(underPos, newState);
        return true;
    }

    protected boolean isCobbleStone(Block block) {
        return block == Blocks.COBBLESTONE || block == Blocks.COBBLESTONE_WALL || block == Blocks.COBBLESTONE_STAIRS || block == Blocks.COBBLESTONE_WALL;
    }

    protected boolean isStoneBrick(Block block) {
        return block == Blocks.STONE_BRICKS || block == Blocks.STONE_BRICK_WALL || block == Blocks.STONE_BRICK_STAIRS || block == Blocks.STONE_BRICK_WALL;
    }

    protected boolean isMossyStoneBrick(Block block) {
        return block == Blocks.MOSSY_STONE_BRICKS || block == Blocks.MOSSY_STONE_BRICK_WALL || block == Blocks.MOSSY_STONE_BRICK_STAIRS || block == Blocks.MOSSY_STONE_BRICK_WALL;
    }

    protected boolean maybeAddMoss(Level world, BlockPos pos, RandomSource rand) {
        List<Vec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<Vec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            Vec3i dir = iterator.next();
            if (dir == null) {
                throw new NullPointerException("dir cannot be null");
            }
            BlockPos sidePos = pos.offset(dir);
            if (sidePos == null) {
                throw new NullPointerException("sidePos cannot be null");
            }
            Block sideBlock = this.getBlock(world, sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBrick(sideBlock)) {
                return false;
            }
            Block mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == Blocks.AIR) {
                return false;
            }
            BlockState sideState = world.getBlockState(sidePos);
            BlockState mossState = mossBlock.defaultBlockState();
            if ((mossState = this.copyProperties(sideState, mossState)) == null) {
                throw new NullPointerException("mossState cannot be null");
            }
            LOGGER.debug("AddMoss '%s' => '%s'", (Object)sideBlock, (Object)mossBlock);
            world.setBlockAndUpdate(sidePos, mossState);
            return true;
        }
        return false;
    }

    public BlockState copyProperties(BlockState source, BlockState target) {
        for (Property rawProperty : source.getProperties()) {
            Property property = rawProperty;
            if (property == null) {
                throw new NullPointerException("property cannot be null");
            }
            if (target.hasProperty(property)) {
                Comparable value = source.getValue(property);
                if (value == null) {
                    throw new NullPointerException("value cannot be null");
                }
                target = (BlockState)target.setValue(property, value);
                continue;
            }
            throw new UnsupportedOperationException(String.format("'%s' property '%s' is not available on '%s'", source.getBlock(), property.getName(), target.getBlock()));
        }
        return target;
    }

    public static enum msb {
        NOT_SOURCE,
        BELOW_SEA_LEVEL,
        NOT_SURFACE_WATER,
        ALREADY_FLOWING,
        MAYBE_NOT_ERODE,
        SUCCESS,
        NOT_FOUND;

    }

    private class wallBreakOption {
        Vec3i dir;
        Integer distance;

        public wallBreakOption(Vec3i dir, Integer distance) {
            this.dir = dir;
            this.distance = distance;
        }
    }
}

