/*
 * Decompiled with CFR 0.152.
 */
package com.kittrider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Configuration {
    public static String ROOT_FOLDER = System.getProperty("user.dir");
    public JSONObject SAVE_VALUES = new JSONObject();
    private File CFG_FILE;
    private File CFG_LOC;

    public Configuration(String saveLoc, String cfgName) {
        System.out.println("CONFIG LOCATION! " + ROOT_FOLDER + "/config/" + saveLoc + "/" + cfgName + ".json");
        this.CFG_FILE = new File(ROOT_FOLDER + "/config/" + saveLoc + "/" + cfgName + ".json");
        this.CFG_LOC = new File(ROOT_FOLDER + "/config/" + saveLoc + "/");
        if (!this.CFG_LOC.exists()) {
            this.CFG_LOC.mkdirs();
        }
    }

    public void finish() {
        if (this.CFG_FILE.exists()) {
            this.load();
        } else {
            this.save();
        }
        this.updateConfig();
    }

    public void setParameter(String key, Object value) {
        this.SAVE_VALUES.put(key, value);
    }

    public void setDefaultParameter(String key, Object defaultValue) {
        if (!this.SAVE_VALUES.containsKey(key)) {
            this.SAVE_VALUES.put(key, defaultValue);
        }
    }

    public Object getParameter(String key) {
        try {
            return this.SAVE_VALUES.get(key);
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public boolean getBool(String key) {
        try {
            return Boolean.valueOf(this.SAVE_VALUES.get(key).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void removeParameter(String key) {
        this.SAVE_VALUES.remove(key);
    }

    public void updateConfig() {
        try {
            FileReader configurationFile = new FileReader(this.CFG_FILE);
            JSONObject obj = (JSONObject)new JSONParser().parse(configurationFile);
            configurationFile.close();
            for (String key : this.SAVE_VALUES.keySet()) {
                obj.put(key, this.SAVE_VALUES.get(key));
            }
            FileOutputStream writer = new FileOutputStream(this.CFG_FILE);
            writer.write(obj.toJSONString().getBytes());
            writer.close();
            System.out.println("[Configuration] Saved Existing File!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try {
            FileOutputStream writer = new FileOutputStream(this.CFG_FILE);
            JSONObject obj = new JSONObject();
            for (String key : this.SAVE_VALUES.keySet()) {
                obj.put(key, this.SAVE_VALUES.get(key));
            }
            writer.write(obj.toJSONString().getBytes());
            writer.close();
            System.out.println("[Configuration] Saved New File!");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void load() {
        System.out.println("[Configuration] Loading...");
        try {
            FileReader configurationFile = new FileReader(this.CFG_FILE);
            JSONObject obj = (JSONObject)new JSONParser().parse(configurationFile);
            for (String key : obj.keySet()) {
                this.SAVE_VALUES.put(key, obj.get(key));
                System.out.println(key + " - " + obj.get(key));
            }
            System.out.println("[Configuration] Loaded!\n\n");
        }
        catch (Exception e) {
            System.out.println("[Configuration] Failed!\n\n");
            e.printStackTrace();
        }
    }
}

