/*
 * Decompiled with CFR 0.152.
 */
package com.kittrider;

import com.kittrider.Configuration;
import com.kittrider.WildfireGender;
import org.json.simple.JSONObject;

public class GenderPlayer {
    public String username;
    public boolean gender;
    public float pBustSize = 0.6f;
    private Configuration cfg;

    public GenderPlayer(String username) {
        this(username, true);
    }

    public GenderPlayer(String username, boolean gender) {
        this.username = username;
        this.gender = gender;
        this.cfg = new Configuration("KittGender", this.username);
        this.cfg.setDefaultParameter("username", "NOT_AVAILABLE");
        this.cfg.setDefaultParameter("gender", true);
        this.cfg.setDefaultParameter("bust_size", Float.valueOf(0.6f));
        this.cfg.finish();
    }

    public Configuration getConfig() {
        return this.cfg;
    }

    public float getBustSize() {
        return this.pBustSize;
    }

    public void updateBustSize(float v) {
        this.pBustSize = v;
    }

    public static JSONObject toJSONObject(GenderPlayer plr) {
        JSONObject obj = new JSONObject();
        obj.put("username", plr.username);
        obj.put("gender", plr.gender);
        obj.put("bust_size", Float.valueOf(plr.pBustSize));
        return obj;
    }

    public void toJSONObject() {
        GenderPlayer.toJSONObject(this);
    }

    public static GenderPlayer fromJSONObject(JSONObject obj) {
        GenderPlayer plr = new GenderPlayer(obj.get("username").toString());
        plr.gender = Boolean.valueOf(obj.get("gender").toString());
        plr.pBustSize = Float.valueOf(obj.get("bust_size").toString()).floatValue();
        return plr;
    }

    public static GenderPlayer loadGenderInfo(String uuid) {
        GenderPlayer plr = WildfireGender.getPlayerByName(uuid);
        plr.gender = plr.getConfig().getBool("gender");
        plr.updateBustSize(Float.valueOf(plr.getConfig().getParameter("bust_size").toString()).floatValue());
        return plr;
    }

    public static void saveGenderInfo(GenderPlayer plr) {
        plr.getConfig().setParameter("username", plr.username);
        plr.getConfig().setParameter("gender", plr.gender);
        plr.getConfig().setParameter("bust_size", Float.valueOf(plr.getBustSize()));
        plr.getConfig().save();
    }
}

