/*
 * Decompiled with CFR 0.152.
 */
package com.kittrider.render;

import com.kittrider.GenderPlayer;
import com.kittrider.WildfireGender;
import com.kittrider.render.SteinModelRenderer;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class LayerExtras
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private SteinModelRenderer.ModelBox chest = new SteinModelRenderer.ModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 8, 5, 4, 0.0f, false);
    private SteinModelRenderer.ModelBox chestwear = new SteinModelRenderer.ModelBox(64, 64, 17, 34, -4.0f, 0.0f, 0.0f, 8, 5, 3, 0.0f, false);
    private SteinModelRenderer.ModelBox sBox = new SteinModelRenderer.ModelBox(64, 32, 17, 19, -4.0f, 0.0f, 0.0f, 8, 5, 3, 0.0f, false);
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public LayerExtras(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> player) {
        super(player);
    }

    public ResourceLocation getArmorResource(AbstractClientPlayerEntity entity, ItemStack stack, EquipmentSlotType slot, String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type);
        ResourceLocation resourcelocation = null;
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
        }
        return resourcelocation;
    }

    public boolean shouldCombineTextures() {
        return true;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn, AbstractClientPlayerEntity ent, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (WildfireGender.modEnabled) {
            AbstractClientPlayerEntity aPlr = ent;
            String playerName = PlayerEntity.func_146094_a((GameProfile)ent.func_146103_bH()).toString();
            GenderPlayer plr = WildfireGender.getPlayerByName(playerName);
            PlayerRenderer rend = (PlayerRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)ent);
            PlayerModel model = (PlayerModel)rend.func_217764_d();
            if (plr != null && !plr.gender) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                boolean isChestplateOccupied = !ent.func_184582_a(EquipmentSlotType.CHEST).equals(new ItemStack((IItemProvider)Items.field_185160_cR, 1), true) && !ent.func_184582_a(EquipmentSlotType.CHEST).equals(new ItemStack((IItemProvider)Items.field_190931_a, 1), true);
                boolean teamSeeFriendly = false;
                if (ent.func_96124_cp() != null) {
                    teamSeeFriendly = ent.func_96124_cp().func_98297_h();
                }
                boolean breathingAnimation = true;
                this.pushMatrix(matrixStack, model.field_78115_e, 0.0f);
                matrixStack.func_227861_a_(0.0, (double)0.05625f, -0.125);
                if (isChestplateOccupied) {
                    matrixStack.func_227861_a_(0.0, 0.0, (double)0.01f);
                }
                matrixStack.func_227863_a_(new Quaternion(-35.0f * plr.getBustSize(), 0.0f, 0.0f, true));
                float f = 1.0f;
                f = (float)ent.func_213322_ci().func_189985_c();
                f /= 0.2f;
                f = f * f * f;
                if (f < 1.0f) {
                    f = 1.0f;
                }
                if (!isChestplateOccupied && breathingAnimation) {
                    float f5 = -MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.45f + 0.45f;
                    matrixStack.func_227863_a_(new Quaternion(f5, 0.0f, 0.0f, true));
                }
                int combineTex = LivingRenderer.func_229117_c_((LivingEntity)ent, (float)0.0f);
                RenderType type = RenderType.func_228644_e_((ResourceLocation)rend.func_110775_a(ent));
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(type);
                if (teamSeeFriendly && ent.func_82150_aj() || !ent.func_82150_aj()) {
                    LayerExtras.renderBox(this.chest, matrixStack, ivertexbuilder, packedLightIn, combineTex, 1.0f, 1.0f, 1.0f, this.getTransparency(ent));
                    if (ent.func_175148_a(PlayerModelPart.JACKET) && !isChestplateOccupied) {
                        matrixStack.func_227861_a_(0.0, 0.0, (double)-0.015f);
                        matrixStack.func_227862_a_(1.05f, 1.05f, 1.05f);
                        LayerExtras.renderBox(this.chestwear, matrixStack, ivertexbuilder, packedLightIn, combineTex, 1.0f, 1.0f, 1.0f, this.getTransparency(ent));
                    }
                }
                if (!ent.field_71071_by.func_70440_f(2).equals(new ItemStack((IItemProvider)Items.field_190931_a, 1), true)) {
                    this.unsetBrightness();
                    ItemStack itemstack = ent.field_71071_by.func_70440_f(2);
                    ResourceLocation ARMOR_TXTR = this.getArmorResource(ent, ent.field_71071_by.func_70440_f(2), EquipmentSlotType.CHEST, null);
                    if (ARMOR_TXTR != null && itemstack.func_77973_b() instanceof ArmorItem) {
                        matrixStack.func_227860_a_();
                        float armorR = 1.0f;
                        float armorG = 1.0f;
                        float armorB = 1.0f;
                        ArmorItem armoritem = (ArmorItem)itemstack.func_77973_b();
                        if (armoritem instanceof IDyeableArmorItem) {
                            int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                            armorR = (float)(i >> 16 & 0xFF) / 255.0f;
                            armorG = (float)(i >> 8 & 0xFF) / 255.0f;
                            armorB = (float)(i & 0xFF) / 255.0f;
                        }
                        matrixStack.func_227861_a_(0.0, (double)0.015f, (double)-0.015f);
                        matrixStack.func_227862_a_(1.05f, 1.0f, 1.0f);
                        RenderType type2 = RenderType.func_228644_e_((ResourceLocation)ARMOR_TXTR);
                        IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(type2);
                        LayerExtras.renderBox(this.sBox, matrixStack, ivertexbuilder2, packedLightIn, combineTex, armorR, armorG, armorB, this.getTransparency(ent));
                        if (ent.field_71071_by.func_70440_f(2).func_77948_v()) {
                            RenderType type3 = RenderType.func_228655_k_();
                            IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(type3);
                            LayerExtras.renderBox(this.sBox, matrixStack, ivertexbuilder3, packedLightIn, combineTex, 1.0f, 1.0f, 1.0f, this.getTransparency(ent));
                        }
                        matrixStack.func_227865_b_();
                    }
                }
                matrixStack.func_227865_b_();
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void unsetBrightness() {
    }

    public void pushMatrix(MatrixStack m, ModelRenderer mdl, float f7) {
        float rPointX = mdl.field_78800_c;
        float rPointY = mdl.field_78797_d;
        float rPointZ = mdl.field_78798_e;
        float rAngleX = mdl.field_78795_f;
        float rAngleY = mdl.field_78796_g;
        float rAngleZ = mdl.field_78808_h;
        m.func_227860_a_();
        m.func_227861_a_((double)(rPointX * 0.0625f), (double)(rPointY * 0.0625f), (double)(rPointZ * 0.0625f));
        if (rAngleZ != 0.0f) {
            m.func_227863_a_(new Quaternion(0.0f, 0.0f, rAngleZ, false));
        }
        if (rAngleY != 0.0f) {
            m.func_227863_a_(new Quaternion(0.0f, rAngleY, 0.0f, false));
        }
        if (rAngleX != 0.0f) {
            m.func_227863_a_(new Quaternion(rAngleX, 0.0f, 0.0f, false));
        }
    }

    public float getTransparency(AbstractClientPlayerEntity ent) {
        boolean flag1;
        float alphaChannel = 1.0f;
        boolean bl = flag1 = ent.func_82150_aj() && !ent.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (flag1) {
            alphaChannel = 0.15f;
        } else if (ent.func_82150_aj()) {
            alphaChannel = 0.0f;
        }
        return alphaChannel;
    }

    public static void renderBox(SteinModelRenderer.ModelBox box, MatrixStack matrixEntryIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixEntryIn.func_227860_a_();
        Matrix4f matrix4f = matrixEntryIn.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrixEntryIn.func_227866_c_().func_227872_b_();
        for (SteinModelRenderer.TexturedQuad modelrenderer$texturedquad : box.quads) {
            Vector3f vector3f = modelrenderer$texturedquad.normal.func_229195_e_();
            vector3f.func_229188_a_(matrix3f);
            float f = vector3f.func_195899_a();
            float f1 = vector3f.func_195900_b();
            float f2 = vector3f.func_195902_c();
            for (int i = 0; i < 4; ++i) {
                SteinModelRenderer.PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                float f3 = modelrenderer$positiontexturevertex.vector3D.func_195899_a() / 16.0f;
                float f4 = modelrenderer$positiontexturevertex.vector3D.func_195900_b() / 16.0f;
                float f5 = modelrenderer$positiontexturevertex.vector3D.func_195902_c() / 16.0f;
                Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                vector4f.func_229372_a_(matrix4f);
                bufferIn.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), red, green, blue, alpha, modelrenderer$positiontexturevertex.texturePositionX, modelrenderer$positiontexturevertex.texturePositionY, packedOverlayIn, packedLightIn, f, f1, f2);
            }
        }
        matrixEntryIn.func_227865_b_();
    }
}

