/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class DodgeEnchantment
extends Enchantment {
    protected static final UUID MODIFIER_UUID = UUID.fromString("ad3e064e-e9f6-4747-a86b-46dc4e2a1444");
    protected static final String MODIFIER_NAME = "KnockBackImmunityTime";
    protected static HashMap<String, Integer> modifiers = new HashMap();

    public DodgeEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_LEGS, new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 2;
    }

    public int func_77321_a(int level) {
        return 14 * level;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack pants = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.DODGE, (EntityLivingBase)entity);
        if (enchantmentLevel > 0) {
            if (!(WonderfulEnchantments.RANDOM.nextDouble() < (double)enchantmentLevel * 0.125)) {
                return;
            }
            for (double d = 0.0; d < 3.0; d += 1.0) {
                ((WorldServer)entity.func_130014_f_()).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * (0.25 * (d + 1.0)), entity.field_70161_v, 32, 0.125, 0.0, 0.125, 0.075, new int[0]);
                ((WorldServer)entity.func_130014_f_()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * (0.25 * (d + 1.0)), entity.field_70161_v, 16, 0.125, 0.0, 0.125, 0.025, new int[0]);
            }
            pants.func_77972_a((int)event.getAmount(), entity);
            if (entity instanceof EntityPlayer) {
                DodgeEnchantment.setImmunity((EntityPlayer)entity, 100);
            }
            event.setCanceled(true);
        }
    }

    private static void setImmunity(EntityPlayer player, int ticks) {
        String nickname = player.func_145748_c_().func_150260_c();
        if (!modifiers.containsKey(nickname)) {
            modifiers.put(nickname, 0);
        }
        modifiers.replace(nickname, ticks);
        DodgeEnchantment.applyImmunity(player);
    }

    private static void applyImmunity(EntityPlayer player) {
        String nickname = player.func_145748_c_().func_150260_c();
        IAttributeInstance resistance = player.func_110148_a(SharedMonsterAttributes.field_111266_c);
        resistance.func_188479_b(MODIFIER_UUID);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, modifiers.get(nickname) > 0 ? 1.0 : 0.0, 0);
        resistance.func_111121_a(modifier);
    }

    @SubscribeEvent
    public static void checkPlayersKnockBackImmunity(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        String nickname = player.func_145748_c_().func_150260_c();
        if (!modifiers.containsKey(nickname)) {
            modifiers.put(nickname, 0);
        }
        DodgeEnchantment.applyImmunity(player);
        modifiers.replace(nickname, Math.max(modifiers.get(nickname) - 1, 0));
    }
}

