/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class FanaticEnchantment
extends Enchantment {
    public FanaticEnchantment(String name) {
        super(Enchantment.Rarity.UNCOMMON, EnumEnchantmentType.FISHING_ROD, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 6;
    }

    public int func_77321_a(int level) {
        return 10 * level;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creature) {
        return (float)level * 1.0f;
    }

    protected boolean func_77326_a(Enchantment enchant) {
        return super.func_77326_a(enchant);
    }

    @SubscribeEvent
    public String func_77316_c(int level) {
        if (level == this.func_77325_b()) {
            String message = TextFormatting.GRAY + new TextComponentTranslation("wonderful_enchantments.true_level", new Object[0]).func_150260_c();
            message = message + TextFormatting.GRAY + " " + new TextComponentTranslation(this.func_77320_a(), new Object[0]).func_150260_c();
            return message;
        }
        return super.func_77316_c(level);
    }

    public boolean func_185261_e() {
        return true;
    }

    @SubscribeEvent
    public static void fishingFanaticEvent(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        LootContext.Builder lootContext$builder = new LootContext.Builder((WorldServer)world).func_186470_a(player).func_186469_a(player.func_184817_da());
        LootTable loottable = player.func_130014_f_().func_184146_ak().func_186521_a(LootTableList.field_186387_al);
        EntityFishHook fishingBobber = event.getHookEntity();
        String reward = ((ItemStack)event.getDrops().get(0)).func_82833_r();
        int fanaticLevel = EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.FISHING_FANATIC, (EntityLivingBase)player);
        HashMultiset rewards = HashMultiset.create();
        rewards.add((Object)reward);
        int extraItemsCounter = 0;
        for (int i = 0; i < fanaticLevel; ++i) {
            if (!(WonderfulEnchantments.RANDOM.nextFloat() < 0.33334f)) continue;
            for (ItemStack itemstack : loottable.func_186462_a(WonderfulEnchantments.RANDOM, lootContext$builder.func_186471_a())) {
                EntityItem entityItem = new EntityItem(world, fishingBobber.field_70165_t + 0.5 * WonderfulEnchantments.RANDOM.nextDouble(), fishingBobber.field_70163_u + 0.25 * WonderfulEnchantments.RANDOM.nextDouble(), fishingBobber.field_70161_v + 0.5 * WonderfulEnchantments.RANDOM.nextDouble(), itemstack);
                double deltaX = player.field_70165_t - entityItem.field_70165_t;
                double deltaY = player.field_70163_u - entityItem.field_70163_u;
                double deltaZ = player.field_70161_v - entityItem.field_70161_v;
                entityItem.func_70016_h(0.1 * deltaX, 0.1 * deltaY + Math.pow(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0), 0.25) * 0.08, 0.1 * deltaZ);
                world.func_72838_d((Entity)entityItem);
                rewards.add((Object)itemstack.func_82833_r());
                ++extraItemsCounter;
            }
        }
        if (FanaticEnchantment.tryIncreaseFishingFanaticLevel(player)) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.BOLD + new TextComponentTranslation("wonderful_enchantments.fanatic_level_up", new Object[0]).func_150260_c()), true);
        } else if (rewards.size() > 1) {
            FanaticEnchantment.notifyPlayerAboutRewards(reward, (Multiset<String>)rewards, player);
        }
        event.damageRodBy(event.getRodDamage() + extraItemsCounter);
        world.func_72838_d((Entity)new EntityXPOrb(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, extraItemsCounter + WonderfulEnchantments.RANDOM.nextInt(2 * extraItemsCounter + 1)));
    }

    private static boolean tryIncreaseFishingFanaticLevel(EntityPlayer player) {
        boolean shouldIncreaseLevel;
        ItemStack fishingRod = player.func_184614_ca();
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.FISHING_FANATIC, (EntityLivingBase)player);
        double increaseChance = (double)(RegistryHandler.FISHING_FANATIC.func_77325_b() - enchantmentLevel) / 100.0;
        boolean bl = shouldIncreaseLevel = WonderfulEnchantments.RANDOM.nextDouble() < increaseChance;
        if (shouldIncreaseLevel && enchantmentLevel < RegistryHandler.FISHING_FANATIC.func_77325_b()) {
            if (enchantmentLevel == 0) {
                fishingRod.func_77966_a(RegistryHandler.FISHING_FANATIC, 1);
            } else {
                NBTTagList nbt = fishingRod.func_77986_q();
                for (int i = 0; i < nbt.func_74745_c(); ++i) {
                    if (!nbt.func_150305_b(i).func_74779_i("id").contains("fishing_fanatic")) continue;
                    nbt.func_150305_b(i).func_74768_a("lvl", enchantmentLevel + 1);
                    break;
                }
                fishingRod.func_77983_a("Enchantments", (NBTBase)nbt);
            }
            return true;
        }
        return false;
    }

    private static void notifyPlayerAboutRewards(String reward, Multiset<String> rewards, EntityPlayer player) {
        TextComponentString message = new TextComponentString(TextFormatting.WHITE + "(");
        ImmutableList rewardList = Multisets.copyHighestCountFirst(rewards).elementSet().asList();
        for (int i = 0; i < rewardList.size(); ++i) {
            message.func_150257_a((ITextComponent)new TextComponentString((i == 0 ? TextFormatting.WHITE : TextFormatting.GOLD) + (String)rewardList.get(i)));
            if (rewards.count(rewardList.get(i)) > 1) {
                message.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + " x" + rewards.count(rewardList.get(i))));
            }
            if (i == rewardList.size() - 1) continue;
            message.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + ", "));
        }
        message.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + ")"));
        player.func_146105_b((ITextComponent)message, true);
    }
}

