/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class HumanSlayerEnchantment
extends EnchantmentDamage {
    public HumanSlayerEnchantment(String name) {
        super(Enchantment.Rarity.UNCOMMON, 3, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add((Enchantment)this);
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 20;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        return 0.0f;
    }

    public String func_77320_a() {
        return new TextComponentTranslation("enchantment.human_slayer", new Object[0]).func_150261_e();
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentDamage);
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAxe ? true : super.func_92089_a(stack);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        Entity damageSource = event.getSource().func_76364_f();
        if (damageSource instanceof EntityPlayer) {
            EntityLivingBase entity = event.getEntityLiving();
            EntityPlayer entitySource = (EntityPlayer)damageSource;
            int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.HUMAN_SLAYER, (EntityLivingBase)entitySource);
            float extraDamage = (float)Math.floor((double)enchantmentLevel * 2.0);
            if (HumanSlayerEnchantment.isHuman((Entity)entity) && enchantmentLevel > 0) {
                ((WorldServer)entitySource.func_130014_f_()).func_175739_a(EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.625, entity.field_70161_v, 24, 0.125, 0.25, 0.125, 0.5, new int[0]);
                event.setAmount(extraDamage + event.getAmount());
            }
        }
    }

    private static boolean isHuman(Entity entity) {
        return entity instanceof EntityVillager || entity instanceof EntityPlayer || entity instanceof EntityWitch;
    }
}

