/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PhoenixDiveEnchantment
extends Enchantment {
    public PhoenixDiveEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 10 + 10 * level;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 30;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentFrostWalker);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        double distance = event.getDistance();
        if (distance > 3.0) {
            EntityLivingBase livingEntity = event.getEntityLiving();
            World world = livingEntity.func_130014_f_();
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.PHOENIX_DIVE, (ItemStack)livingEntity.func_184582_a(EntityEquipmentSlot.FEET));
            if (enchantmentLevel > 0) {
                double range = 5.0;
                List entities = world.func_72839_b((Entity)livingEntity, livingEntity.func_174813_aQ().func_72317_d(-range, (double)(-livingEntity.field_70131_O) * 0.5, -range).func_72321_a(range * 2.0, 0.0, range * 2.0));
                for (Entity e : entities) {
                    if (!(e instanceof EntityLiving)) continue;
                    EntityLiving entity = (EntityLiving)e;
                    entity.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)livingEntity), (float)Math.sqrt((double)enchantmentLevel * distance));
                    entity.func_70015_d(20 * (2 * enchantmentLevel));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.PHOENIX_DIVE, (ItemStack)boots);
            if (player.func_70093_af() && enchantmentLevel > 0) {
                player.func_70016_h(player.field_70159_w, player.field_70181_x * (1.0 + (double)(enchantmentLevel + 1) * 0.25), player.field_70179_y);
                boots.func_77972_a(3, (EntityLivingBase)player);
            }
        }
    }
}

