/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class VitalityEnchantment
extends Enchantment {
    protected static final UUID MODIFIER_UUID = UUID.fromString("575cb29a-1ee4-11eb-adc1-0242ac120002");
    protected static final String MODIFIER_NAME = "VitalityBonus";

    public VitalityEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 5 + 8 * level;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 10;
    }

    protected boolean func_77326_a(Enchantment enchant) {
        return super.func_77326_a(enchant);
    }

    public boolean func_92089_a(ItemStack stack) {
        return super.func_92089_a(stack) && stack.func_77973_b() instanceof ItemShield;
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        IAttributeInstance maxHealth = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        maxHealth.func_188479_b(MODIFIER_UUID);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, (double)(2 * VitalityEnchantment.getVitalityBonus(entity)), 0);
        maxHealth.func_111121_a(modifier);
    }

    private static int getVitalityBonus(EntityLivingBase entity) {
        int sum = 0;
        ItemStack item1 = entity.func_184614_ca();
        ItemStack item2 = entity.func_184592_cb();
        if (item1.func_77973_b() instanceof ItemShield) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.VITALITY, (ItemStack)item1);
        }
        if (item2.func_77973_b() instanceof ItemShield) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.VITALITY, (ItemStack)item2);
        }
        return sum;
    }
}

