/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DodgeEnchantment
extends Enchantment {
    protected static final UUID MODIFIER_UUID = UUID.fromString("ad3e064e-e9f6-4747-a86b-46dc4e2a1444");
    protected static final String MODIFIER_NAME = "KnockBackImmunityTime";
    protected static HashMap<String, Integer> modifiers = new HashMap();

    public DodgeEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.ARMOR_LEGS, new EquipmentSlotType[]{EquipmentSlotType.LEGS});
    }

    public int func_77325_b() {
        return 2;
    }

    public int func_77321_a(int level) {
        return 14 * level;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack pants = entity.func_184582_a(EquipmentSlotType.LEGS);
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.DODGE.get()), (ItemStack)pants);
        if (enchantmentLevel > 0) {
            if (!(WonderfulEnchantments.RANDOM.nextDouble() < (double)enchantmentLevel * 0.125)) {
                return;
            }
            for (double d = 0.0; d < 3.0; d += 1.0) {
                ((ServerWorld)entity.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197601_L, entity.func_226277_ct_(), entity.func_226283_e_(0.25 * (d + 1.0)), entity.func_226281_cx_(), 32, 0.125, 0.0, 0.125, 0.075);
                ((ServerWorld)entity.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197594_E, entity.func_226277_ct_(), entity.func_226283_e_(0.25 * (d + 1.0)), entity.func_226281_cx_(), 16, 0.125, 0.0, 0.125, 0.025);
            }
            pants.func_222118_a((int)event.getAmount(), entity, e -> e.func_213361_c(EquipmentSlotType.LEGS));
            if (entity instanceof PlayerEntity) {
                DodgeEnchantment.setImmunity((PlayerEntity)entity, 100);
            }
            event.setCanceled(true);
        }
    }

    private static void setImmunity(PlayerEntity player, int ticks) {
        String nickname = player.func_145748_c_().getString();
        if (!modifiers.containsKey(nickname)) {
            modifiers.put(nickname, 0);
        }
        modifiers.replace(nickname, ticks);
        DodgeEnchantment.applyImmunity(player);
    }

    private static void applyImmunity(PlayerEntity player) {
        String nickname = player.func_145748_c_().getString();
        IAttributeInstance resistance = player.func_110148_a(SharedMonsterAttributes.field_111266_c);
        resistance.func_188479_b(MODIFIER_UUID);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, modifiers.get(nickname) > 0 ? 1.0 : 0.0, AttributeModifier.Operation.ADDITION);
        resistance.func_111121_a(modifier);
    }

    @SubscribeEvent
    public static void checkPlayersKnockBackImmunity(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        String nickname = player.func_145748_c_().getString();
        if (!modifiers.containsKey(nickname)) {
            modifiers.put(nickname, 0);
        }
        DodgeEnchantment.applyImmunity(player);
        modifiers.replace(nickname, Math.max(modifiers.get(nickname) - 1, 0));
    }
}

