/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantments;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class FanaticEnchantment
extends Enchantment {
    public FanaticEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentType.FISHING_ROD, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77325_b() {
        return 6;
    }

    public int func_77321_a(int level) {
        return 10 * level;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    public float func_152376_a(int level, CreatureAttribute creature) {
        return (float)level * 1.0f;
    }

    public ITextComponent func_200305_d(int level) {
        if (level == this.func_77325_b()) {
            return new StringTextComponent(TextFormatting.GRAY + new TranslationTextComponent("wonderful_enchantments.true_level", new Object[0]).func_150261_e() + " " + new TranslationTextComponent(this.func_77320_a(), new Object[0]).func_150261_e());
        }
        return super.func_200305_d(level);
    }

    public boolean func_185261_e() {
        return true;
    }

    @SubscribeEvent
    public static void fishingFanaticEvent(ItemFishedEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        LootContext.Builder lootContext$builder = new LootContext.Builder((ServerWorld)world).func_216015_a(LootParameters.field_216286_f, (Object)player.func_180425_c()).func_216015_a(LootParameters.field_216289_i, (Object)player.func_184614_ca()).func_216023_a(WonderfulEnchantments.RANDOM).func_186469_a(player.func_184817_da());
        LootTable loottable = ServerLifecycleHooks.getCurrentServer().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
        FishingBobberEntity fishingBobber = event.getHookEntity();
        String reward = ((ItemStack)event.getDrops().get(0)).func_200301_q().getString();
        int fanaticLevel = EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)RegistryHandler.FISHING_FANATIC.get()), (LivingEntity)player);
        HashMultiset rewards = HashMultiset.create();
        rewards.add((Object)reward);
        int extraItemsCounter = 0;
        for (int i = 0; i < fanaticLevel; ++i) {
            if (!(WonderfulEnchantments.RANDOM.nextFloat() < 0.33334f)) continue;
            for (ItemStack itemstack : loottable.func_216113_a(lootContext$builder.func_216022_a(LootParameterSets.field_216262_c))) {
                ItemEntity entityItem = new ItemEntity(world, fishingBobber.func_226277_ct_() + 0.5 * WonderfulEnchantments.RANDOM.nextDouble(), fishingBobber.func_226278_cu_() + 0.25 * WonderfulEnchantments.RANDOM.nextDouble(), fishingBobber.func_226281_cx_() + 0.5 * WonderfulEnchantments.RANDOM.nextDouble(), itemstack);
                double deltaX = player.func_226277_ct_() - entityItem.func_226277_ct_();
                double deltaY = player.func_226278_cu_() - entityItem.func_226278_cu_();
                double deltaZ = player.func_226281_cx_() - entityItem.func_226281_cx_();
                entityItem.func_213293_j(0.1 * deltaX, 0.1 * deltaY + Math.pow(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0), 0.25) * 0.08, 0.1 * deltaZ);
                world.func_217376_c((Entity)entityItem);
                rewards.add((Object)entityItem.func_145748_c_().getString());
                ++extraItemsCounter;
            }
        }
        if (FanaticEnchantment.tryIncreaseFishingFanaticLevel(player)) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.BOLD + new TranslationTextComponent("wonderful_enchantments.fanatic_level_up", new Object[0]).func_150261_e()), true);
        } else if (rewards.size() > 1) {
            FanaticEnchantment.notifyPlayerAboutRewards(reward, (Multiset<String>)rewards, player);
        }
        event.damageRodBy(event.getRodDamage() + extraItemsCounter);
        world.func_217376_c((Entity)new ExperienceOrbEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, extraItemsCounter + WonderfulEnchantments.RANDOM.nextInt(2 * extraItemsCounter + 1)));
    }

    private static boolean tryIncreaseFishingFanaticLevel(PlayerEntity player) {
        boolean shouldIncreaseLevel;
        ItemStack fishingRod = player.func_184614_ca();
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)RegistryHandler.FISHING_FANATIC.get()), (LivingEntity)player);
        double increaseChance = (double)(((Enchantment)RegistryHandler.FISHING_FANATIC.get()).func_77325_b() - enchantmentLevel) / 100.0;
        boolean bl = shouldIncreaseLevel = WonderfulEnchantments.RANDOM.nextDouble() < increaseChance;
        if (shouldIncreaseLevel && enchantmentLevel < ((Enchantment)RegistryHandler.FISHING_FANATIC.get()).func_77325_b()) {
            if (enchantmentLevel == 0) {
                fishingRod.func_77966_a((Enchantment)RegistryHandler.FISHING_FANATIC.get(), 1);
            } else {
                ListNBT nbt = fishingRod.func_77986_q();
                for (int i = 0; i < nbt.size(); ++i) {
                    if (!nbt.func_150305_b(i).func_74779_i("id").contains("fishing_fanatic")) continue;
                    nbt.func_150305_b(i).func_74768_a("lvl", enchantmentLevel + 1);
                    break;
                }
                fishingRod.func_77983_a("Enchantments", (INBT)nbt);
            }
            return true;
        }
        return false;
    }

    private static void notifyPlayerAboutRewards(String reward, Multiset<String> rewards, PlayerEntity player) {
        StringTextComponent message = new StringTextComponent(TextFormatting.WHITE + "(");
        ImmutableList rewardList = Multisets.copyHighestCountFirst(rewards).elementSet().asList();
        for (int i = 0; i < rewardList.size(); ++i) {
            message.func_150257_a((ITextComponent)new StringTextComponent((i == 0 ? TextFormatting.WHITE : TextFormatting.GOLD) + (String)rewardList.get(i)));
            if (rewards.count(rewardList.get(i)) > 1) {
                message.func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + " x" + rewards.count(rewardList.get(i))));
            }
            if (i == rewardList.size() - 1) continue;
            message.func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.WHITE + ", "));
        }
        message.func_150257_a((ITextComponent)new StringTextComponent(TextFormatting.WHITE + ")"));
        player.func_146105_b((ITextComponent)message, true);
    }
}

