/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.EnchantmentTypes;
import com.wonderfulenchantments.RegistryHandler;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VitalityEnchantment
extends Enchantment {
    protected static final UUID MODIFIER_UUID = UUID.fromString("575cb29a-1ee4-11eb-adc1-0242ac120002");
    protected static final String MODIFIER_NAME = "VitalityBonus";

    public VitalityEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentTypes.SHIELD, new EquipmentSlotType[]{EquipmentSlotType.OFFHAND});
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 5 + 8 * level;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 10;
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        IAttributeInstance maxHealth = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        maxHealth.func_188479_b(MODIFIER_UUID);
        AttributeModifier modifier = new AttributeModifier(MODIFIER_UUID, MODIFIER_NAME, (double)(2 * VitalityEnchantment.getVitalityBonus(entity)), AttributeModifier.Operation.ADDITION);
        maxHealth.func_111121_a(modifier);
    }

    private static int getVitalityBonus(LivingEntity entity) {
        int sum = 0;
        ItemStack item1 = entity.func_184614_ca();
        ItemStack item2 = entity.func_184592_cb();
        if (item1.func_77973_b() instanceof ShieldItem) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.VITALITY.get()), (ItemStack)item1);
        }
        if (item2.func_77973_b() instanceof ShieldItem) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.VITALITY.get()), (ItemStack)item2);
        }
        return sum;
    }
}

