/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import net.minecraft.enchantment.DamageEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HumanSlayerEnchantment
extends DamageEnchantment {
    public HumanSlayerEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, 3, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 20;
    }

    public float func_152376_a(int level, CreatureAttribute creatureType) {
        return 0.0f;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof AxeItem ? true : super.func_92089_a(stack);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        Entity damageSource = event.getSource().func_76364_f();
        if (damageSource instanceof LivingEntity) {
            LivingEntity entity = event.getEntityLiving();
            LivingEntity entitySource = (LivingEntity)damageSource;
            float extraDamage = (float)Math.floor(2.0f * (float)EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)RegistryHandler.HUMAN_SLAYER.get()), (LivingEntity)entitySource));
            if (HumanSlayerEnchantment.isHuman((Entity)entity) && extraDamage > 0.0f) {
                ((ServerWorld)entitySource.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197622_o, entity.func_226277_ct_(), entity.func_226283_e_(0.625), entity.func_226281_cx_(), 24, 0.125, 0.25, 0.125, 0.5);
                event.setAmount(extraDamage + event.getAmount());
            }
        }
    }

    private static boolean isHuman(Entity entity) {
        return entity instanceof VillagerEntity || entity instanceof WanderingTraderEntity || entity instanceof PlayerEntity || entity instanceof WitchEntity || entity instanceof AbstractIllagerEntity;
    }
}

