/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PhoenixDiveEnchantment
extends Enchantment {
    protected static List<Vector3d> positionsToGenerateParticles = new ArrayList<Vector3d>();

    public PhoenixDiveEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.ARMOR_FEET, new EquipmentSlotType[]{EquipmentSlotType.FEET});
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 10 + 10 * level;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + 30;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof FrostWalkerEnchantment);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        double distance = event.getDistance();
        if (distance > 3.0) {
            LivingEntity livingEntity = event.getEntityLiving();
            World world = livingEntity.func_130014_f_();
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.PHOENIX_DIVE.get()), (ItemStack)livingEntity.func_184582_a(EquipmentSlotType.FEET));
            if (enchantmentLevel > 0) {
                double range = 5.0;
                List entities = world.func_72839_b(livingEntity.getEntity(), livingEntity.func_174813_aQ().func_72317_d(-range, (double)(-livingEntity.func_213302_cg()) * 0.5, -range).func_72321_a(range * 2.0, 0.0, range * 2.0));
                for (Entity e : entities) {
                    if (!(e instanceof LivingEntity)) continue;
                    LivingEntity entity = (LivingEntity)e;
                    entity.func_70097_a(DamageSource.func_188405_b((LivingEntity)livingEntity), (float)Math.sqrt((double)enchantmentLevel * distance));
                    entity.func_70015_d(20 * (2 * enchantmentLevel));
                }
                positionsToGenerateParticles.add(livingEntity.func_213303_ch());
            }
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.WorldTickEvent event) {
        if (positionsToGenerateParticles.size() > 0) {
            for (Vector3d position : positionsToGenerateParticles) {
                for (double d = 0.0; d < 3.0; d += 1.0) {
                    ((ServerWorld)event.world).func_195598_a((IParticleData)RegistryHandler.PHOENIX_PARTICLE.get(), position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), (int)Math.pow(4.0, d + 1.0), 0.0625, 0.125, 0.0625, 0.125 * (d + 1.0));
                }
            }
            positionsToGenerateParticles.clear();
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack boots = entity.func_184582_a(EquipmentSlotType.FEET);
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.PHOENIX_DIVE.get()), (ItemStack)boots);
            if (player.func_213453_ef() && enchantmentLevel > 0) {
                player.func_213317_d(player.func_213322_ci().func_216369_h(new Vector3d(0.0, 1.0 + (double)(enchantmentLevel + 1) * 0.25, 0.0)));
                boots.func_222118_a(3, (LivingEntity)player, e -> e.func_213361_c(EquipmentSlotType.FEET));
            }
        }
    }
}

