/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.block.Block;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xerca.xercamod.client.CarvingStationScreen;
import xerca.xercamod.client.DonerTileEntityRenderer;
import xerca.xercamod.client.GuiFunctionalBookcase;
import xerca.xercamod.client.HookSound;
import xerca.xercamod.client.RenderConfettiBallFactory;
import xerca.xercamod.client.RenderCushionFactory;
import xerca.xercamod.client.RenderHookFactory;
import xerca.xercamod.client.RenderTomatoFactory;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.Proxy;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.entity.EntityHook;
import xerca.xercamod.common.item.ItemGrabHook;
import xerca.xercamod.common.item.ItemScythe;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class ClientProxy
extends Proxy {
    private static final ResourceLocation spyglassBlurTexture = new ResourceLocation("xercamod", "textures/misc/spyglass_blur.png");
    private static final ResourceLocation blackTexture = new ResourceLocation("xercamod", "textures/misc/black.png");
    private static Minecraft mc;

    private static void renderSpyglass(MainWindow window) {
        int y1r;
        int x1r;
        int y2l;
        int x2l;
        int x2;
        int x1;
        int y2;
        int y1;
        int width = window.func_198107_o();
        int height = window.func_198087_p();
        boolean x1l = false;
        boolean y1l = false;
        int x2r = width;
        int y2r = height;
        if (width > height) {
            y1 = 0;
            y2 = height;
            x1 = (width - height) / 2;
            x2 = width - x1;
            x2l = x1;
            y2l = height;
            x1r = x1 + height;
            y1r = 0;
        } else {
            x1 = 0;
            x2 = width;
            y1 = (height - width) / 2;
            y2 = height - y1;
            x2l = width;
            y2l = y1;
            x1r = 0;
            y1r = y1 + width;
        }
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        mc.func_110434_K().func_110577_a(spyglassBlurTexture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x1, (double)y2, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2, (double)y2, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2, (double)y1, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x1, (double)y1, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_178965_a();
        mc.func_110434_K().func_110577_a(blackTexture);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x1l, (double)y2l, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2l, (double)y2l, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2l, (double)y1l, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x1l, (double)y1l, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_178965_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x1r, (double)y2r, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2r, (double)y2r, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x2r, (double)y1r, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x1r, (double)y1r, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class ForgeBusSubscriber {
        ForgeBusSubscriber() {
        }

        @SubscribeEvent
        public static void hookReturningEvent(HookReturningEvent ev) {
            EntityHook ent = (EntityHook)ev.getEntity();
            if (ent.field_70170_p.field_72995_K) {
                mc.func_147118_V().func_147682_a((ISound)new HookSound(ent, true));
            }
        }

        @SubscribeEvent
        public static void entityConstEvent(EntityEvent.EntityConstructing ev) {
            Entity ent = ev.getEntity();
            if (ent instanceof EntityHook) {
                EntityHook hook = (EntityHook)ent;
                if (ent.field_70170_p.field_72995_K) {
                    mc.func_147118_V().func_147682_a((ISound)new HookSound(hook, false));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            XercaMod.LOGGER.debug("ClientLoggedOut Event");
            Config.bakeConfig();
        }

        @SubscribeEvent
        public static void gameOverlayEvent(RenderGameOverlayEvent.Post event) {
            ClientPlayerEntity player;
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && (player = mc.field_71439_g).func_184607_cu().func_77973_b() == Items.SPYGLASS && player.func_184605_cv() > 0 && mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
                ClientProxy.renderSpyglass(event.getWindow());
            }
        }

        @SubscribeEvent
        public static void fovEvent(FOVUpdateEvent updateEvent) {
            PlayerEntity player = updateEvent.getEntity();
            if (player.func_184607_cu().func_77973_b() == Items.SPYGLASS && player.func_184605_cv() > 0 && mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
                updateEvent.setNewfov(updateEvent.getNewfov() / 8.0f);
            }
        }

        @SubscribeEvent
        public static void inputUpdateEvent(InputUpdateEvent updateEvent) {
            ItemStack activeItem = updateEvent.getPlayer().func_184607_cu();
            if (activeItem.func_77973_b() instanceof ItemWarhammer && updateEvent.getPlayer().func_184587_cr()) {
                int legerityLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_QUICK, (ItemStack)activeItem);
                if (legerityLevel > 4) {
                    legerityLevel = 4;
                }
                float bonus = 3.0f + 0.5f * (float)legerityLevel;
                updateEvent.getMovementInput().field_78902_a *= bonus;
                updateEvent.getMovementInput().field_192832_b *= bonus;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    static class ModBusSubscriber {
        ModBusSubscriber() {
        }

        @SubscribeEvent
        public static void clientSetupHandler(FMLClientSetupEvent event) {
            ScreenManager.func_216911_a(XercaTileEntities.CONTAINER_FUNCTIONAL_BOOKCASE, GuiFunctionalBookcase::new);
            ScreenManager.func_216911_a(XercaTileEntities.CONTAINER_CARVING_STATION, CarvingStationScreen::new);
            RenderingRegistry.registerEntityRenderingHandler(Entities.TOMATO, (IRenderFactory)new RenderTomatoFactory());
            RenderingRegistry.registerEntityRenderingHandler(Entities.CONFETTI_BALL, (IRenderFactory)new RenderConfettiBallFactory());
            RenderingRegistry.registerEntityRenderingHandler(Entities.HOOK, (IRenderFactory)new RenderHookFactory());
            RenderingRegistry.registerEntityRenderingHandler(Entities.CUSHION, (IRenderFactory)new RenderCushionFactory());
            ClientRegistry.bindTileEntityRenderer(XercaTileEntities.DONER, DonerTileEntityRenderer::new);
            RenderTypeLookup.setRenderLayer((Block)Blocks.BLOCK_TEA_PLANT, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.BLOCK_TOMATO_PLANT, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.BLOCK_RICE_PLANT, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_1, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_2, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_3, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_4, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_5, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_6, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_7, (RenderType)RenderType.func_228641_d_());
            RenderTypeLookup.setRenderLayer((Block)Blocks.CARVED_ACACIA_8, (RenderType)RenderType.func_228641_d_());
            ModBusSubscriber.registerItemModelsProperties();
            mc = Minecraft.func_71410_x();
        }

        private static void registerItemModelsProperties() {
            IItemPropertyGetter warhammerPull = (stack, worldIn, entityIn) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.func_184607_cu().func_77973_b() instanceof ItemWarhammer ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            };
            IItemPropertyGetter grabHookPull = (stack, worldIn, entityIn) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.func_184607_cu().func_77973_b() instanceof ItemGrabHook ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            };
            IItemPropertyGetter scythePull = (stack, worldIn, entityIn) -> {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.func_184607_cu().func_77973_b() instanceof ItemScythe ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            };
            IItemPropertyGetter pulling = (stack, worldIn, entityIn) -> entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            ItemModelsProperties.func_239418_a_((Item)Items.STONE_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.STONE_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.WOODEN_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.WOODEN_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.IRON_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.IRON_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.GOLDEN_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.GOLDEN_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.DIAMOND_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.DIAMOND_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.NETHERITE_SCYTHE, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)scythePull);
            ItemModelsProperties.func_239418_a_((Item)Items.NETHERITE_SCYTHE, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)grabHookPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_GRAB_HOOK, (ResourceLocation)new ResourceLocation("cast"), (stack, worldIn, entityIn) -> {
                if (!stack.func_77942_o()) {
                    return 0.0f;
                }
                CompoundNBT tag = stack.func_77978_p();
                if (!tag.func_74764_b("cast")) {
                    return 0.0f;
                }
                return tag.func_74767_n("cast") ? 1.0f : 0.0f;
            });
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_STONE_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)warhammerPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_STONE_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_IRON_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)warhammerPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_IRON_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_GOLD_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)warhammerPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_GOLD_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_DIAMOND_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)warhammerPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_DIAMOND_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_NETHERITE_WARHAMMER, (ResourceLocation)new ResourceLocation("pull"), (IItemPropertyGetter)warhammerPull);
            ItemModelsProperties.func_239418_a_((Item)Items.ITEM_NETHERITE_WARHAMMER, (ResourceLocation)new ResourceLocation("pulling"), (IItemPropertyGetter)pulling);
        }

        @SubscribeEvent
        public static void handleItemColors(ColorHandlerEvent.Item event) {
            if (Items.FLASK != null) {
                event.getItemColors().func_199877_a((itemStack, colorIndex) -> colorIndex > 0 ? -1 : PotionUtils.func_190932_c((ItemStack)itemStack), new IItemProvider[]{Items.FLASK});
            }
            if (Items.ENDER_BOW != null) {
                event.getItemColors().func_199877_a((itemStack, colorIndex) -> colorIndex > 0 ? -1 : PotionUtils.func_190932_c((ItemStack)itemStack), new IItemProvider[]{Items.ENDER_BOW});
            }
        }
    }
}

