/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.EnchantedItemTrade;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ConfigSyncPacket;

@Mod.EventBusSubscriber(modid="xercamod")
class EventHandler {
    EventHandler() {
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent ev) {
        if (Config.isFoodEnabled() && ev.getType().equals(VillagerProfession.field_221156_f)) {
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((IItemProvider)Items.ITEM_RICE_SEEDS, 24), new ItemStack((IItemProvider)net.minecraft.item.Items.field_151166_bC), 16, 2, 0.05f));
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((IItemProvider)Items.ITEM_TOMATO, 22), new ItemStack((IItemProvider)net.minecraft.item.Items.field_151166_bC), 16, 2, 0.05f));
            ((List)ev.getTrades().get(1)).add(new BasicTrade(new ItemStack((IItemProvider)Items.ITEM_TEA_LEAF, 18), new ItemStack((IItemProvider)net.minecraft.item.Items.field_151166_bC), 16, 2, 0.05f));
        }
        if (Config.isScytheEnabled() && ev.getType().equals(VillagerProfession.field_221164_n)) {
            ((List)ev.getTrades().get(1)).add(new BasicTrade(1, new ItemStack((IItemProvider)Items.STONE_SCYTHE), 12, 1, 0.2f));
            ((List)ev.getTrades().get(3)).add(new EnchantedItemTrade((Item)Items.IRON_SCYTHE, 2, 3, 10, 0.2f));
            ((List)ev.getTrades().get(4)).add(new EnchantedItemTrade((Item)Items.DIAMOND_SCYTHE, 5, 3, 15, 0.2f));
        }
        if (Config.isWarhammerEnabled() && ev.getType().equals(VillagerProfession.field_221165_o)) {
            ((List)ev.getTrades().get(3)).add(new EnchantedItemTrade(Items.ITEM_IRON_WARHAMMER, 3, 3, 20, 0.2f));
            ((List)ev.getTrades().get(5)).add(new EnchantedItemTrade(Items.ITEM_DIAMOND_WARHAMMER, 10, 3, 30, 0.2f));
        }
    }

    @SubscribeEvent
    public static void craftEvent(PlayerEvent.ItemCraftedEvent ev) {
        Item result = ev.getCrafting().func_77973_b();
        if (result == Items.ITEM_GRAB_HOOK || result == Items.ITEM_KNIFE || result == Items.CARVING_STATION) {
            for (int i = 0; i < ev.getInventory().func_70302_i_(); ++i) {
                ItemStack item = ev.getInventory().func_70301_a(i);
                if (item.func_77973_b() != Items.ITEM_KNIFE) continue;
                ev.getInventory().func_70299_a(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        XercaMod.LOGGER.debug("PlayerLoggedIn Event: Syncing config");
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)event.getPlayer();
        ConfigSyncPacket pack = Config.makePacket();
        XercaMod.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)pack);
        Triggers.CONFIG_CHECK.test(serverPlayer);
        ArrayList<IRecipe> recipesToRemove = new ArrayList<IRecipe>();
        for (IRecipe r : serverPlayer.field_71133_b.func_199529_aN().func_199510_b()) {
            if (!r.func_199560_c().func_110624_b().equals("xercamod")) continue;
            String path = r.func_199560_c().func_110623_a();
            for (String conditionName : Config.conditionMap.keySet()) {
                int slash;
                if (Config.conditionMap.get(conditionName).get().booleanValue() || (slash = path.indexOf("/")) <= 0 || !conditionName.equals(path.substring(0, slash)) || !serverPlayer.func_192037_E().func_193830_f(r)) continue;
                XercaMod.LOGGER.warn("Removing Recipe " + path);
                recipesToRemove.add(r);
            }
        }
        if (!recipesToRemove.isEmpty()) {
            serverPlayer.func_192037_E().func_197925_b(recipesToRemove, serverPlayer);
            for (IRecipe r : recipesToRemove) {
                Advancement advancement = serverPlayer.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation("xercamod", "recipes/" + r.func_199560_c().func_110623_a()));
                serverPlayer.func_192039_O().func_192744_b(advancement, "config");
                serverPlayer.func_192039_O().func_192744_b(advancement, "has_item");
                serverPlayer.func_192039_O().func_192744_b(advancement, "has_the_recipe");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickedBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        ItemStack heldItem = event.getPlayer().func_184586_b(event.getHand());
        if (world.func_180495_p(event.getPos()).func_177230_c() == net.minecraft.block.Blocks.field_150411_aY && heldItem.func_77973_b() == net.minecraft.item.Items.field_179561_bm) {
            world.func_175656_a(event.getPos(), Blocks.BLOCK_DONER.func_176223_P());
            heldItem.func_190918_g(1);
            world.func_184133_a(null, event.getPos(), SoundEvents.field_187884_fr, SoundCategory.BLOCKS, 0.8f, 0.9f + world.field_73012_v.nextFloat() * 0.1f);
        }
    }
}

