/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamod.common.Config;

public class SeedLootModifier
extends LootModifier {
    private final Item itemSeed;
    private final boolean isFood;

    protected SeedLootModifier(ILootCondition[] conditionsIn, Item itemSeed, boolean isFood) {
        super(conditionsIn);
        this.itemSeed = itemSeed;
        this.isFood = isFood;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.isFood && !Config.isFoodEnabled() || !this.isFood && !Config.isTeaEnabled()) {
            return generatedLoot;
        }
        generatedLoot.add(new ItemStack((IItemProvider)this.itemSeed));
        return generatedLoot;
    }

    static class Serializer
    extends GlobalLootModifierSerializer<SeedLootModifier> {
        Serializer() {
        }

        public SeedLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            Item seed = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"seedItem")));
            boolean isFood = JSONUtils.func_151212_i((JsonObject)object, (String)"isFood");
            return new SeedLootModifier(conditionsIn, seed, isFood);
        }

        public JsonObject write(SeedLootModifier instance) {
            JsonObject json = new JsonObject();
            ResourceLocation itemRL = Registry.field_212630_s.func_177774_c((Object)instance.itemSeed);
            json.addProperty("seedItem", itemRL.toString());
            json.addProperty("isFood", Boolean.valueOf(instance.isFood));
            return json;
        }
    }
}

