/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.crafting;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeConditionSmelting
extends FurnaceRecipe {
    private final Supplier<Boolean> condition;
    private IRecipeSerializer serializer;

    public RecipeConditionSmelting(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookTimeIn, Supplier<Boolean> condition) {
        super(idIn, groupIn, ingredientIn, resultIn, experienceIn, cookTimeIn);
        this.condition = condition;
    }

    public RecipeConditionSmelting(FurnaceRecipe furnaceRecipe, Supplier<Boolean> condition, IRecipeSerializer serializer) {
        super(furnaceRecipe.func_199560_c(), furnaceRecipe.func_193358_e(), (Ingredient)furnaceRecipe.func_192400_c().get(0), furnaceRecipe.func_77571_b(), furnaceRecipe.func_222138_b(), furnaceRecipe.func_222137_e());
        this.condition = condition;
        this.serializer = serializer;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (!this.condition.get().booleanValue()) {
            return false;
        }
        return super.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(IInventory inv) {
        if (!this.condition.get().booleanValue()) {
            return ItemStack.field_190927_a;
        }
        return super.func_77572_b(inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public void setSerializer(IRecipeSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeConditionSmelting> {
        private static final CookingRecipeSerializer<FurnaceRecipe> furnaceSerializer = IRecipeSerializer.field_222171_o;
        private final Supplier<Boolean> condition;

        public Serializer(Supplier<Boolean> condition) {
            this.condition = condition;
        }

        public RecipeConditionSmelting read(ResourceLocation recipeId, JsonObject json) {
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)furnaceSerializer.func_199425_a_(recipeId, json);
            return new RecipeConditionSmelting(furnaceRecipe, this.condition, this);
        }

        public RecipeConditionSmelting read(ResourceLocation recipeId, PacketBuffer buffer) {
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)furnaceSerializer.func_199426_a_(recipeId, buffer);
            return new RecipeConditionSmelting(furnaceRecipe, this.condition, this);
        }

        public void write(PacketBuffer buffer, RecipeConditionSmelting recipe) {
            furnaceSerializer.func_199427_a_(buffer, (AbstractCookingRecipe)recipe);
        }
    }
}

