/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ScytheAttackPacket;

@ParametersAreNonnullByDefault
public class ItemScythe
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of();

    public ItemScythe(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super((float)attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder.addToolType(ToolType.PICKAXE, tier.func_200925_d()));
    }

    public float func_150893_a(ItemStack stack, BlockState blockState) {
        if (blockState.func_177230_c() instanceof CropsBlock) {
            if (((CropsBlock)blockState.func_177230_c()).func_185525_y(blockState)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        int sweeping = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)itemstack);
        if (sweeping > 0) {
            World world = player.field_70170_p;
            BlockState southBS = world.func_180495_p(pos.func_177968_d());
            BlockState northBS = world.func_180495_p(pos.func_177978_c());
            BlockState westBS = world.func_180495_p(pos.func_177976_e());
            BlockState eastBS = world.func_180495_p(pos.func_177974_f());
            if (this.isMaxCrop(southBS)) {
                this.breakBlock(pos.func_177968_d(), world, player);
            }
            if (this.isMaxCrop(northBS)) {
                this.breakBlock(pos.func_177978_c(), world, player);
            }
            if (this.isMaxCrop(westBS)) {
                this.breakBlock(pos.func_177976_e(), world, player);
            }
            if (this.isMaxCrop(eastBS)) {
                this.breakBlock(pos.func_177974_f(), world, player);
            }
            if (sweeping > 1) {
                BlockState seBS = world.func_180495_p(pos.func_177968_d().func_177974_f());
                BlockState swBS = world.func_180495_p(pos.func_177968_d().func_177976_e());
                BlockState neBS = world.func_180495_p(pos.func_177978_c().func_177976_e());
                BlockState nwBS = world.func_180495_p(pos.func_177978_c().func_177974_f());
                if (this.isMaxCrop(seBS)) {
                    this.breakBlock(pos.func_177968_d().func_177974_f(), world, player);
                }
                if (this.isMaxCrop(swBS)) {
                    this.breakBlock(pos.func_177968_d().func_177976_e(), world, player);
                }
                if (this.isMaxCrop(neBS)) {
                    this.breakBlock(pos.func_177978_c().func_177976_e(), world, player);
                }
                if (this.isMaxCrop(nwBS)) {
                    this.breakBlock(pos.func_177978_c().func_177974_f(), world, player);
                }
            }
        }
        return false;
    }

    private void breakBlock(BlockPos pos, World world, PlayerEntity player) {
        world.func_225521_a_(pos, true, (Entity)player);
    }

    private boolean isMaxCrop(BlockState bs) {
        return bs.func_177230_c() instanceof TallGrassBlock || bs.func_177230_c() instanceof CropsBlock && ((CropsBlock)bs.func_177230_c()).func_185525_y(bs);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.field_77351_y == EnchantmentType.BREAKABLE || ench == Enchantments.field_185308_t || ench == Items.ENCHANTMENT_GUILLOTINE || ench == Enchantments.field_185302_k || ench == Enchantments.field_185303_l || ench == Enchantments.field_191530_r || ench == Enchantments.field_180312_n || ench == Enchantments.field_185304_p;
    }

    public static CompoundNBT getSkullNBT(List<Integer> id, String texture) {
        CompoundNBT skullNBT = new CompoundNBT();
        CompoundNBT propertiesNBT = new CompoundNBT();
        ListNBT texturesNBT = new ListNBT();
        CompoundNBT tNBT = new CompoundNBT();
        tNBT.func_74778_a("Value", texture);
        texturesNBT.add((Object)tNBT);
        propertiesNBT.func_218657_a("textures", (INBT)texturesNBT);
        skullNBT.func_218657_a("Properties", (INBT)propertiesNBT);
        skullNBT.func_197646_b("Id", id);
        return skullNBT;
    }

    public static void spawnHead(LivingEntity target) {
        if (target instanceof PlayerEntity) {
            ItemScythe.spawnHead((PlayerEntity)target, target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        } else if (target.func_200600_R() == EntityType.field_200796_j) {
            ItemScythe.spawnHead(Arrays.asList(-2094654955, 1289635317, -2072061254, -1389687975), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDBlNGU2ZmJmNWYzZGNmOTQ0MjJhMWYzMTk0NDhmMTUyMzY5ZDE3OWRiZmJjZGYwMGU1YmZlODQ5NWZhOTc3In19fQ==", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.cow");
        } else if (target.func_200600_R() == EntityType.field_200757_aw) {
            ItemScythe.spawnHead(Arrays.asList(-417497690, -2115092234, -1652637095, -1368159706), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWM2Y2Q3MjAyYzM0ZTc4ZjMwNzMwOTAzNDlmN2Q5NzNiMjg4YWY1ZTViNzMzNGRkMjQ5MDEwYjNmMjcwNzhmOSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.iron_golem");
        } else if (target.func_200600_R() == EntityType.field_200781_U) {
            ItemScythe.spawnHead(Arrays.asList(26786972, -1196471604, -1857097459, -1977271489), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTE4YjZiNzk3ODMzNjhkZmUwMDQyOTg1MTEwZGEzNjZmOWM3ODhiNDUwOTdhM2VhNmQwZDlhNzUzZTlmNDJjNiJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.ocelot");
        } else if (target.func_200600_R() == EntityType.field_200792_f) {
            ItemScythe.spawnHead(Arrays.asList(-1988261685, -188068212, -1178146933, -1658240924), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDA2ZTM0MmY5MGVjNTM4YWFhMTU1MmIyMjRmMjY0YTA0MDg0MDkwMmUxMjZkOTFlY2U2MTM5YWE1YjNjN2NjMyJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.blaze");
        } else if (target.func_200600_R() == EntityType.field_200784_X) {
            ItemScythe.spawnHead(Arrays.asList(1003849902, -32486937, -1481465560, 1732265), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTU2MmEzN2I4NzFmOTY0YmZjM2UxMzExZWE2NzJhYWEwMzk4NGE1ZGM0NzIxNTRhMzRkYzI1YWYxNTdlMzgyYiJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.pig");
        } else if (target.func_200600_R() == EntityType.field_200743_ai) {
            ItemScythe.spawnHead(Arrays.asList(-1039916148, -57717813, -1391423156, -248573967), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODZjMjdiMDEzZjFiZjMzNDQ4NjllODFlNWM2MTAwMjdiYzQ1ZWM1Yjc5NTE0ZmRjOTZlMDFkZjFiN2UzYTM4NyJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.slime");
        } else if (target.func_200600_R() == EntityType.field_200756_av) {
            ItemScythe.spawnHead(Arrays.asList(-579522334, -80917881, -1713988716, 921668381), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjRiZDgzMjgxM2FjMzhlNjg2NDg5MzhkN2EzMmY2YmEyOTgwMWFhZjMxNzQwNDM2N2YyMTRiNzhiNGQ0NzU0YyJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.villager");
        } else if (target.func_200600_R() == EntityType.field_200794_h) {
            ItemScythe.spawnHead(Arrays.asList(202094529, 1049906219, -1603801553, 1961515467), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzdiMDcwNjNhNjg3NGZhM2UyMjU0OGUwMjA2MmJkNzMzYzI1ODg1OTI5ODA5NjI0MTgwYWViYjg1MTU1N2Y2YSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.cave_spider");
        } else if (target.func_200600_R() == EntityType.field_200803_q) {
            ItemScythe.spawnHead(Arrays.asList(-620677106, -2030549868, -1207093980, 1829338684), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWIwOWEzNzUyNTEwZTkxNGIwYmRjOTA5NmIzOTJiYjM1OWY3YThlOGE5NTY2YTAyZTdmNjZmYWZmOGQ2Zjg5ZSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.enderman");
        } else if (target.func_200600_R() == EntityType.field_200771_K) {
            ItemScythe.spawnHead(Arrays.asList(-1846771288, 385960253, -1088350611, -1439946228), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDkwZDYxZThjZTk1MTFhMGEyYjVlYTI3NDJjYjFlZjM2MTMxMzgwZWQ0MTI5ZTFiMTYzY2U4ZmYwMDBkZThlYSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.magma_cube");
        } else if (target.func_200600_R() == EntityType.field_233592_ba_) {
            ItemScythe.spawnHead(Arrays.asList(-174221110, 851921639, -1251029810, -1727624143), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTE2ZDE2N2M1NzQ0ZWQxNGViYzAyZjQ0N2YzMjYxNDA1OTM2MmI3ZDJlY2I4MDhmZjA2MTY1ZDJjMzQzYmVmMiJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.zombie_pigman");
        } else if (target.func_200600_R() == EntityType.field_200748_an) {
            ItemScythe.spawnHead(Arrays.asList(848845569, -89043442, -1563667252, 1307407919), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjYxYTQ5NTQxYTgzNmFhOGY0Zjc2ZTBkNGNiMmZmMDQ4ODhjNjJmOTQxMWVhMTBjYmFjZjFmMmE1NDQyNDI0MCJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.spider");
        } else if (target.func_200600_R() == EntityType.field_200795_i) {
            ItemScythe.spawnHead(Arrays.asList(1799972324, 1156335733, -1788030142, 1902426427), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTE2YjhlOTgzODljNTQxYmIzNjQ1Mzg1MGJjYmQxZjdiYzVhNTdkYTYyZGNjNTA1MDYwNDA5NzM3ZWM1YjcyYSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.chicken");
        } else if (target.func_200600_R() == EntityType.field_200811_y) {
            ItemScythe.spawnHead(Arrays.asList(1340996983, -1860222137, -1353501742, -1474776410), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGE0ZTQyZWIxNWEwODgxM2E2YTZmNjFmMTBhYTI4ODAxOWZhMGZhZTEwNmEyOTUzZGRiNDZmNzdlZTJkNzdmIn19fQ==", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.ghast");
        } else if (target.func_200600_R() == EntityType.field_200780_T) {
            ItemScythe.spawnHead(Arrays.asList(-1612461734, 989744374, -1157404361, 1657691129), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTIzY2ZjNTU4MjQ1NGZjZjk5MDZmODQxZmRhMmNjNmFlODk2Y2Y0NTU4MjFjNGFkYTE5OThkZTcwODc3Y2M4NiJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.mooshroom");
        } else if (target.func_200600_R() == EntityType.field_200737_ac) {
            ItemScythe.spawnHead(Arrays.asList(262421674, -1762178383, -1870145564, 1689656607), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2NhMzhjY2Y0MTdlOTljYTlkNDdlZWIxNWE4YTMwZWRiMTUwN2FhNTJiNjc4YzIyMGM3MTdjNDc0YWE2ZmUzZSJ9fX0=", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.sheep");
        } else if (target.func_200600_R() == EntityType.field_200749_ao) {
            ItemScythe.spawnHead(Arrays.asList(-1940995388, 882658030, -1188418964, 246238058), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWU4OTEwMWQ1Y2M3NGFhNDU4MDIxYTA2MGY2Mjg5YTUxYTM1YTdkMzRkOGNhZGRmYzNjZGYzYjJjOWEwNzFhIn19fQ==", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.squid");
        }
    }

    private static void spawnHead(INBT skullOwner, World world, double x, double y, double z, @Nullable String nameTransKey) {
        ItemStack playerHead = new ItemStack((IItemProvider)net.minecraft.item.Items.field_196184_dx, 1);
        CompoundNBT headNBT = playerHead.func_196082_o();
        headNBT.func_218657_a("SkullOwner", skullOwner);
        if (nameTransKey != null) {
            playerHead.func_200302_a((ITextComponent)new TranslationTextComponent(nameTransKey));
        }
        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)playerHead);
    }

    private static void spawnHead(List<Integer> id, String texture, World world, double x, double y, double z, @Nullable String nameTransKey) {
        ItemScythe.spawnHead((INBT)ItemScythe.getSkullNBT(id, texture), world, x, y, z, nameTransKey);
    }

    private static void spawnHead(PlayerEntity player, World world, double x, double y, double z) {
        ItemScythe.spawnHead((INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)player.func_146103_bH()), world, x, y, z, null);
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isScytheEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack) > 0) {
            boolean sweep;
            float damage = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float bonusDamage = entity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)entity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float cooldownStrength = player.func_184825_o(0.5f);
            damage *= 0.2f + cooldownStrength * cooldownStrength * 0.8f;
            damage += (bonusDamage *= cooldownStrength);
            boolean cooledAttack = cooldownStrength > 0.9f;
            boolean cooledSprintAttack = player.func_70051_ag() && cooledAttack;
            boolean critical = cooledAttack && player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH() && entity instanceof LivingEntity && !player.func_70051_ag();
            double d0 = player.field_70140_Q - player.field_70141_P;
            boolean bl = sweep = cooledAttack && !critical && !cooledSprintAttack && player.func_233570_aj_() && d0 < (double)player.func_70689_ay();
            if (sweep) {
                float sweepDamage = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)player) * damage;
                for (LivingEntity livingentity : player.field_70170_p.func_217357_a(LivingEntity.class, entity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                    if (livingentity == player || livingentity == entity || player.func_184191_r((Entity)livingentity) || livingentity instanceof ArmorStandEntity && ((ArmorStandEntity)livingentity).func_181026_s() || !(player.func_70068_e((Entity)livingentity) < 9.0)) continue;
                    livingentity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                    livingentity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), sweepDamage);
                }
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                player.func_184810_cG();
            }
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)heldItem) > 0) {
            playerIn.func_184598_c(hand);
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return UseAction.BOW;
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return 72000;
        }
        return 0;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) <= 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        float f = (float)(this.func_77626_a(stack) - timeLeft) / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f >= 0.9) {
            player.func_184609_a(Hand.MAIN_HAND);
            if (worldIn.field_72995_K) {
                Minecraft mine = Minecraft.func_71410_x();
                if (mine.field_71476_x != null && mine.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity target = ((EntityRayTraceResult)mine.field_71476_x).func_216348_a();
                    ScytheAttackPacket pack = new ScytheAttackPacket(f, target.func_145782_y());
                    XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent text = new TranslationTextComponent("xercamod.scythe_tooltip");
        tooltip.add((ITextComponent)text.func_240699_a_(TextFormatting.BLUE));
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            TranslationTextComponent textGuillotine = new TranslationTextComponent("xercamod.guillotine_tooltip");
            tooltip.add((ITextComponent)textGuillotine.func_240699_a_(TextFormatting.YELLOW));
        }
    }
}

