/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.block.BlockTeapot;
import xerca.xercamod.common.item.Items;

public class ItemTeapot
extends BlockItem {
    public static final int maxTea = 7;
    private final int teaAmount;
    private final boolean isHot;

    public ItemTeapot(BlockTeapot blockTeapot, int teaAmount, boolean isHot) {
        super((Block)blockTeapot, (teaAmount == 7 ? new Item.Properties().func_200916_a((ItemGroup)Items.teaTab) : new Item.Properties()).func_200915_b(7));
        this.teaAmount = teaAmount;
        this.isHot = isHot;
        String baseName = isHot ? "item_hot_teapot_" : "item_full_teapot_";
        this.setRegistryName(baseName + teaAmount);
    }

    public int getTeaAmount() {
        return this.teaAmount;
    }

    public boolean isHot() {
        return this.isHot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(this.isHot ? "Hot" : "Cold"));
        tooltip.add((ITextComponent)new StringTextComponent("Tea amount: " + this.teaAmount));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isTeaEnabled()) {
            return;
        }
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext context) {
        Object blockstate = context.func_195996_i().func_77973_b() instanceof ItemTeapot ? (!((ItemTeapot)context.func_195996_i().func_77973_b()).isHot ? null : (BlockState)this.func_179223_d().func_196258_a(context).func_206870_a((Property)BlockTeapot.TEA_AMOUNT, (Comparable)Integer.valueOf(((ItemTeapot)context.func_195996_i().func_77973_b()).teaAmount))) : this.func_179223_d().func_196258_a(context);
        return blockstate != null && this.func_195944_a(context, (BlockState)blockstate) ? blockstate : null;
    }
}

