/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3i;
import xerca.xercamod.common.packets.ParticlePacket;

public class ConfettiParticlePacket
extends ParticlePacket {
    private Vector3i direction;

    public ConfettiParticlePacket(int count, double posX, double posY, double posZ) {
        this(count, posX, posY, posZ, Vector3i.field_177959_e);
    }

    public ConfettiParticlePacket(int count, double posX, double posY, double posZ, Vector3i direction) {
        super(count, posX, posY, posZ);
        this.direction = direction;
    }

    public ConfettiParticlePacket() {
    }

    @Override
    public void read(PacketBuffer buf) {
        super.read(buf);
        this.direction = new Vector3i(buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void write(PacketBuffer buf) {
        super.write(buf);
        buf.writeInt(this.direction.func_177958_n());
        buf.writeInt(this.direction.func_177956_o());
        buf.writeInt(this.direction.func_177952_p());
    }

    public static ConfettiParticlePacket decode(PacketBuffer buf) {
        ConfettiParticlePacket result = new ConfettiParticlePacket();
        try {
            result.read(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading ConfettiParticlePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(ConfettiParticlePacket pkt, PacketBuffer buf) {
        pkt.write(buf);
    }

    public Vector3i getDirection() {
        return this.direction;
    }
}

