/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.profiles;

import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumLifeStage;
import com.github.ipixeli.gender.core.options.EnumModel;
import com.github.ipixeli.gender.core.options.Options;

public final class PlayerProfile {
    private String name = "";
    private String uuid = "";
    private EnumGender gender = EnumGender.UNSET;
    private EnumAge age = EnumAge.UNSET;
    private EnumModel model = EnumModel.UNSET;

    public PlayerProfile(String n, String u) {
        this.name = n;
        this.uuid = u;
    }

    public PlayerProfile(String n, String u, EnumAge a, EnumGender g, EnumModel m) {
        this.name = n;
        this.uuid = u;
        this.age = a;
        this.gender = g;
        this.model = m;
    }

    public String name() {
        return this.name;
    }

    public String uuid() {
        return this.uuid;
    }

    public EnumAge getAge() {
        return this.age;
    }

    public EnumGender getGender() {
        return this.gender;
    }

    public EnumModel getModel() {
        return this.model;
    }

    public void setUsername(String s) {
        this.name = s;
    }

    public void setUUID(String s) {
        this.uuid = s;
    }

    public void setAge(EnumAge v) {
        this.age = v;
        this.model = this.selectModel(this.model);
    }

    public void setGender(EnumGender v) {
        this.gender = v;
        this.model = this.selectModel(this.model);
    }

    public void setModel(EnumModel v) {
        this.model = this.selectModel(v);
    }

    private EnumModel selectModel(EnumModel m) {
        if (this.gender.equals(EnumGender.UNSET) || this.gender.equals(EnumGender.MALE) || this.age.lifeStage.equals((Object)EnumLifeStage.CHILD) || m.getStageUnlock().id > this.age.lifeStage.id) {
            return EnumModel.NONE;
        }
        if (!m.equals(this.model)) {
            return this.getNextAbled(m);
        }
        return this.model;
    }

    private EnumModel getNextAbled(EnumModel m) {
        for (int i = 0; i < Options.listModels.size(); ++i) {
            EnumModel next = m.next(true);
            if (next.getStageUnlock().id < this.age.lifeStage.id) continue;
            return next;
        }
        return EnumModel.NONE;
    }

    public boolean isSamePlayer(PlayerProfile p2) {
        return this.name().equals(p2.name()) && this.uuid().equals(p2.uuid());
    }
}

