/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.client.MCC;
import com.github.ipixeli.gender.core.client.assets.Asset;
import com.github.ipixeli.gender.forge.GenderForge;
import com.github.ipixeli.gender.forge.client.gui.ListScreen;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public final class MCAccessor
implements MCC {
    private static final Random r = new Random();
    private static Minecraft mc;
    private static MCAccessor instance;

    public MCAccessor(Minecraft mcIn) {
        mc = mcIn;
        instance = this;
    }

    public static MCAccessor instance() {
        return instance;
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public void bindTexture(ResourceLocation res) {
        mc.func_110434_K().func_110577_a(res);
    }

    @Override
    public void displayScreen(Object screen) {
        mc.func_147108_a((Screen)screen);
        if (screen == null) {
            mc.func_213228_a(true);
        }
    }

    @Override
    public String getMCVer() {
        return mc.func_175600_c();
    }

    @Override
    public String getName(Object playerEntity) {
        return ((PlayerEntity)playerEntity).func_200200_C_().func_150261_e();
    }

    @Override
    public String getUuid(Object playerEntity) {
        return ((PlayerEntity)playerEntity).func_110124_au().toString();
    }

    @Override
    public String getSelfUsername() {
        if (this.getSelfEntity() != null) {
            return this.getName(this.getSelfEntity());
        }
        if (mc.func_110432_I() != null) {
            return mc.func_110432_I().func_111285_a();
        }
        return "whoami";
    }

    @Override
    public String getSelfUuid() {
        if (this.getSelfEntity() != null) {
            return this.getUuid(this.getSelfEntity());
        }
        if (mc.func_110432_I() != null) {
            return mc.func_110432_I().func_148255_b();
        }
        return "whoami";
    }

    public ClientPlayerEntity getSelfEntity() {
        return MCAccessor.mc.field_71439_g;
    }

    @Override
    public boolean isSelf(Object player) {
        boolean sameName = this.getSelfUsername().equals(this.getName(player));
        boolean sameID = this.getSelfUuid().equals(this.getUuid(player));
        return sameName && sameID;
    }

    private List<AbstractClientPlayerEntity> getPlayers() {
        return MCAccessor.mc.field_71441_e.func_217369_A();
    }

    @Override
    public Object getPlayerByUuid(String uuidStr) {
        UUID uuidObj = UUID.fromString(uuidStr);
        List list = this.getPlayers().stream().filter(e -> e.func_110124_au().equals(uuidObj)).collect(Collectors.toList());
        return list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public void addParticle(double x, double y, double z) {
        double xSpeed = r.nextGaussian() * 0.02;
        double ySpeed = r.nextGaussian() * 0.02;
        double zSpeed = r.nextGaussian() * 0.02;
        MCAccessor.mc.field_71438_f.func_195461_a((IParticleData)ParticleTypes.field_197633_z, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void play(Asset a, float pitch, float x, float y, float z) {
        if (a == null) {
            GenderForge.logger.logErr("The provided sound asset is null.");
            return;
        }
        ResourceLocation resource = (ResourceLocation)a.get();
        if (resource == null) {
            GenderForge.logger.logErr("The located resource sound is null.");
            return;
        }
        SoundCategory cat = SoundCategory.PLAYERS;
        SimpleSound sound = new SimpleSound(resource, cat, 1.0f, pitch, false, 0, ISound.AttenuationType.NONE, (double)x, (double)y, (double)z, true);
        mc.func_147118_V().func_147682_a((ISound)sound);
    }

    public ResourceLocation getResource(String s) {
        return new ResourceLocation(s);
    }

    @Override
    public boolean isIntegratedServer() {
        return mc.func_71401_C() != null && mc.func_71401_C().func_71264_H();
    }

    @Override
    public boolean isGuiRender() {
        Screen screen = MCAccessor.mc.field_71462_r;
        return screen instanceof ProfileScreen || screen instanceof ListScreen;
    }
}

