/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.server;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.server.AccessorMCS;
import com.github.ipixeli.gender.forge.server.GenderServer;
import com.github.ipixeli.gender.forge.server.ServerCmd;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gender")
public final class ServerEvents {
    @SubscribeEvent
    public void onEvent(RegisterCommandsEvent e) {
        new ServerCmd().register((CommandDispatcher<CommandSource>)e.getDispatcher());
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.PlayerLoggedInEvent e) {
        if (!(e.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity newPlayer = (ServerPlayerEntity)e.getPlayer();
        String newPlayerName = newPlayer.func_200200_C_().func_150261_e();
        NetworkManager destination = newPlayer.field_71135_a.func_147298_b();
        for (String name : AccessorMCS.getConnectedPlayers()) {
            PlayerProfile p = Gender.server().getListManager().get(name, null);
            if (p == null || p.name() == newPlayerName) continue;
            GenderServer.sendToClient(p, destination);
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.PlayerLoggedOutEvent e) {
        if (!(e.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity oldPlayer = (ServerPlayerEntity)e.getPlayer();
        BaseListMgr manager = Gender.server().getListManager();
        PlayerProfile p = manager.get(AccessorMCS.getName(oldPlayer), AccessorMCS.getUUID(oldPlayer));
        if (p != null) {
            manager.removePlayer(p);
        }
    }
}

