/*
 * Decompiled with CFR 0.152.
 */
package net.theancients.ancient_realms3.world.dimension;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.EndChunkGenerator;
import net.minecraft.world.gen.EndGenerationSettings;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import net.theancients.ancient_realms3.AncientRealms3ModElements;
import net.theancients.ancient_realms3.block.AirStoneBlock;
import net.theancients.ancient_realms3.block.SkyWaterBlock;
import net.theancients.ancient_realms3.procedures.AeriumPlayerEntersDimensionProcedure;

@AncientRealms3ModElements.ModElement.Tag
public class AeriumDimension
extends AncientRealms3ModElements.ModElement {
    @ObjectHolder(value="ancient_realms3:aerium")
    public static final ModDimension dimension = null;
    public static DimensionType type = null;
    private static Biome[] dimensionBiomes;

    public AeriumDimension(AncientRealms3ModElements instance) {
        super(instance, 871);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void registerDimension(RegistryEvent.Register<ModDimension> event) {
        event.getRegistry().register(new CustomModDimension().setRegistryName("aerium"));
    }

    @SubscribeEvent
    public void onRegisterDimensionsEvent(RegisterDimensionsEvent event) {
        if (DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("ancient_realms3:aerium")) == null) {
            DimensionManager.registerDimension((ResourceLocation)new ResourceLocation("ancient_realms3:aerium"), (ModDimension)dimension, null, (boolean)true);
        }
        type = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("ancient_realms3:aerium"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        dimensionBiomes = new Biome[]{(Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:fallen_lands")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:plain_lands")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:sky_forest")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:sun_lands")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:lose_lands")), (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation("ancient_realms3:carav_forest"))};
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity entity = event.getPlayer();
        World world = entity.field_70170_p;
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        if (event.getTo() == type) {
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", world);
            AeriumPlayerEntersDimensionProcedure.executeProcedure($_dependencies);
        }
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private final Layer genBiomes;
        private final Layer biomeFactoryLayer;
        private final Biome[] biomes;
        private final SimplexNoiseGenerator generator;

        public BiomeProviderCustom(World world) {
            Layer[] aLayer = this.makeTheWorld(world.func_72905_C());
            this.genBiomes = aLayer[0];
            this.biomeFactoryLayer = aLayer[1];
            this.biomes = dimensionBiomes;
            this.generator = new SimplexNoiseGenerator((Random)new SharedSeedRandom(world.func_72905_C()));
        }

        private Layer[] makeTheWorld(long seed) {
            LongFunction<IExtendedNoiseRandom> contextFactory = l -> new LazyAreaLayerContext(25, seed, l);
            IAreaFactory parentLayer = IslandLayer.INSTANCE.func_202823_a(contextFactory.apply(1L));
            IAreaFactory biomeLayer = new BiomeLayerCustom().func_202713_a(contextFactory.apply(200L), parentLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1000L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1001L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1002L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1003L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1004L), biomeLayer);
            biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1005L), biomeLayer);
            IAreaFactory voronoizoom = VoroniZoomLayer.INSTANCE.func_202713_a(contextFactory.apply(10L), biomeLayer);
            return new Layer[]{new Layer(biomeLayer), new Layer(voronoizoom)};
        }

        public Biome func_201545_a(int x, int y) {
            return this.biomeFactoryLayer.func_215738_a(x, y);
        }

        public Biome func_222366_b(int p_222366_1_, int p_222366_2_) {
            return this.genBiomes.func_215738_a(p_222366_1_, p_222366_2_);
        }

        public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
            return this.biomeFactoryLayer.func_202833_a(x, z, width, length);
        }

        public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
            int i = centerX - sideLength >> 2;
            int j = centerZ - sideLength >> 2;
            int k = centerX + sideLength >> 2;
            int l = centerZ + sideLength >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            HashSet set = Sets.newHashSet();
            Collections.addAll(set, this.genBiomes.func_202833_a(i, j, i1, j1));
            return set;
        }

        @Nullable
        public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
            int i = x - range >> 2;
            int j = z - range >> 2;
            int k = x + range >> 2;
            int l = z + range >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            Biome[] abiome = this.genBiomes.func_202833_a(i, j, i1, j1);
            BlockPos blockpos = null;
            int k1 = 0;
            for (int l1 = 0; l1 < i1 * j1; ++l1) {
                int i2 = i + l1 % i1 << 2;
                int j2 = j + l1 / i1 << 2;
                if (!biomes.contains(abiome[l1])) continue;
                if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                    blockpos = new BlockPos(i2, 0, j2);
                }
                ++k1;
            }
            return blockpos;
        }

        public boolean func_205004_a(Structure<?> structureIn) {
            return this.field_205005_a.computeIfAbsent(structureIn, p_205006_1_ -> {
                for (Biome biome : this.biomes) {
                    if (!biome.func_201858_a(p_205006_1_)) continue;
                    return true;
                }
                return false;
            });
        }

        public Set<BlockState> func_205706_b() {
            if (this.field_205707_b.isEmpty()) {
                for (Biome biome : this.biomes) {
                    this.field_205707_b.add(biome.func_203944_q().func_204108_a());
                }
            }
            return this.field_205707_b;
        }

        public float func_222365_c(int p_222365_1_, int p_222365_2_) {
            int i = p_222365_1_ / 2;
            int j = p_222365_2_ / 2;
            int k = p_222365_1_ % 2;
            int l = p_222365_2_ % 2;
            float f = 100.0f - MathHelper.func_76129_c((float)(p_222365_1_ * p_222365_1_ + p_222365_2_ * p_222365_2_)) * 8.0f;
            f = MathHelper.func_76131_a((float)f, (float)-100.0f, (float)80.0f);
            for (int i1 = -12; i1 <= 12; ++i1) {
                for (int j1 = -12; j1 <= 12; ++j1) {
                    long k1 = i + i1;
                    long l1 = j + j1;
                    if (k1 * k1 + l1 * l1 <= 4096L || !(this.generator.func_151605_a((double)k1, (double)l1) < (double)-0.9f)) continue;
                    float f1 = (MathHelper.func_76135_e((float)k1) * 3439.0f + MathHelper.func_76135_e((float)l1) * 147.0f) % 13.0f + 9.0f;
                    float f2 = k - i1 * 2;
                    float f3 = l - j1 * 2;
                    float f4 = 100.0f - MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3)) * f1;
                    f4 = MathHelper.func_76131_a((float)f4, (float)-100.0f, (float)80.0f);
                    f = Math.max(f, f4);
                }
            }
            return f;
        }
    }

    public static class BiomeLayerCustom
    implements IC0Transformer {
        public int func_202726_a(INoiseRandom context, int value) {
            return Registry.field_212624_m.func_148757_b((Object)dimensionBiomes[context.func_202696_a(dimensionBiomes.length)]);
        }
    }

    public static class ChunkProviderModded
    extends EndChunkGenerator {
        public ChunkProviderModded(IWorld world, BiomeProvider provider) {
            super(world, provider, new EndGenerationSettings(){

                public BlockState func_205532_l() {
                    return AirStoneBlock.block.func_176223_P();
                }

                public BlockState func_205533_m() {
                    return SkyWaterBlock.block.func_176223_P();
                }
            });
            this.field_222558_e.func_202423_a(3946);
        }
    }

    public static class CustomDimension
    extends Dimension {
        private BiomeProviderCustom biomeProviderCustom = null;

        public CustomDimension(World world, DimensionType type) {
            super(world, type);
            this.field_76576_e = false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public Vec3d func_76562_b(float cangle, float ticks) {
            return new Vec3d(0.290196078431, 0.698039215686, 0.8);
        }

        public ChunkGenerator<?> func_186060_c() {
            if (this.biomeProviderCustom == null) {
                this.biomeProviderCustom = new BiomeProviderCustom(this.field_76579_a);
            }
            return new ChunkProviderModded((IWorld)this.field_76579_a, this.biomeProviderCustom);
        }

        public boolean func_76569_d() {
            return true;
        }

        public boolean func_76567_e() {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_76568_b(int x, int z) {
            return false;
        }

        public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
            return IForgeDimension.SleepResult.ALLOW;
        }

        @Nullable
        public BlockPos func_206920_a(ChunkPos chunkPos, boolean checkValid) {
            return null;
        }

        @Nullable
        public BlockPos func_206921_a(int x, int z, boolean checkValid) {
            return null;
        }

        public boolean func_177500_n() {
            return false;
        }

        public float func_76563_a(long worldTime, float partialTicks) {
            double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
            double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
            return (float)(d0 * 2.0 + d1) / 3.0f;
        }
    }

    public static class CustomModDimension
    extends ModDimension {
        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return CustomDimension::new;
        }
    }
}

