/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.container.implementations.CraftAmountContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.CraftRequestPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CraftAmountScreen
extends AEBaseScreen<CraftAmountContainer> {
    private final AESubScreen subGui;
    private NumberEntryWidget amountToCraft;
    private Button next;

    public CraftAmountScreen(CraftAmountContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.subGui = new AESubScreen(this, container.getTarget());
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.amountToCraft = new NumberEntryWidget(this, 20, 30, 138, 62, NumberEntryType.CRAFT_ITEM_COUNT);
        this.amountToCraft.setValue(1L);
        this.amountToCraft.setTextFieldBounds(62, 57, 50);
        this.amountToCraft.setMinValue(1L);
        this.amountToCraft.setHideValidationIcon(true);
        this.amountToCraft.addButtons(this.field_230705_e_::add, arg_0 -> ((CraftAmountScreen)this).func_230480_a_(arg_0));
        this.next = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.text(), this::confirm));
        this.amountToCraft.setOnConfirm(() -> this.confirm(this.next));
        this.subGui.addBackButton(arg_0 -> ((CraftAmountScreen)this).func_230480_a_(arg_0), 154, 0);
        this.func_231049_c__(true);
    }

    private void confirm(Button button) {
        int amount = this.amountToCraft.getIntValue().orElse(0);
        if (amount <= 0) {
            return;
        }
        NetworkHandler.instance().sendToServer(new CraftRequestPacket(amount, CraftAmountScreen.func_231173_s_()));
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.SelectAmount.text().getString(), 8.0f, 6.0f, 0x404040);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.next.func_238482_a_(CraftAmountScreen.func_231173_s_() ? GuiText.Start.text() : GuiText.Next.text());
        this.bindTexture("guis/craft_amt.png");
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.func_230927_p_());
        this.next.field_230693_o_ = this.amountToCraft.getIntValue().orElse(0) > 0;
        this.amountToCraft.render(matrixStack, offsetX, offsetY, partialTicks);
    }
}

