/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.util.Platform;
import com.google.common.base.Joiner;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmContainer> {
    private final AESubScreen subGui;
    private final int rows = 5;
    private final IItemList<IAEItemStack> storage = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IItemList<IAEItemStack> pending = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IItemList<IAEItemStack> missing = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private Button start;
    private Button selectCPU;
    private int tooltip = -1;

    public CraftConfirmScreen(CraftConfirmContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.subGui = new AESubScreen(this, container.getTarget());
        this.field_146999_f = 238;
        this.field_147000_g = 206;
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.start = new Button(this.field_147003_i + 162, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Start.text(), btn -> this.start());
        this.start.field_230693_o_ = false;
        this.func_230480_a_((Widget)this.start);
        this.selectCPU = new Button(this.field_147003_i + 19, this.field_147009_r + this.field_147000_g - 68, 180, 20, this.getNextCpuButtonLabel(), btn -> this.selectNextCpu());
        this.selectCPU.field_230693_o_ = false;
        this.func_230480_a_((Widget)this.selectCPU);
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 6, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.text(), btn -> this.subGui.goBack()));
        this.setScrollBar();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float btn) {
        this.updateCPUButtonText();
        this.start.field_230693_o_ = !((CraftConfirmContainer)this.field_147002_h).hasNoCPU() && !this.isSimulation();
        this.selectCPU.field_230693_o_ = !this.isSimulation();
        int gx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int gy = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, btn);
    }

    private void updateCPUButtonText() {
        this.selectCPU.func_238482_a_(this.getNextCpuButtonLabel());
    }

    private ITextComponent getNextCpuButtonLabel() {
        if (((CraftConfirmContainer)this.field_147002_h).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        ITextComponent cpuName = ((CraftConfirmContainer)this.field_147002_h).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmContainer)this.field_147002_h).cpuName;
        return GuiText.CraftingCPU.withSuffix(": ").func_230529_a_(cpuName);
    }

    private boolean isSimulation() {
        return ((CraftConfirmContainer)this.field_147002_h).isSimulation();
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        long BytesUsed = ((CraftConfirmContainer)this.field_147002_h).getUsedBytes();
        String byteUsed = NumberFormat.getInstance().format(BytesUsed);
        String Add = BytesUsed > 0L ? byteUsed + ' ' + GuiText.BytesUsed.getLocal() : GuiText.CalculatingWait.getLocal();
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.CraftingPlan.getLocal() + " - " + Add, 8.0f, 7.0f, 0x404040);
        String dsp = null;
        dsp = this.isSimulation() ? GuiText.Simulation.getLocal() : (((CraftConfirmContainer)this.field_147002_h).getCpuAvailableBytes() > 0L ? GuiText.Bytes.getLocal() + ": " + ((CraftConfirmContainer)this.field_147002_h).getCpuAvailableBytes() + " : " + GuiText.CoProcessors.getLocal() + ": " + ((CraftConfirmContainer)this.field_147002_h).getCpuCoProcessors() : GuiText.Bytes.getLocal() + ": N/A : " + GuiText.CoProcessors.getLocal() + ": N/A");
        int offset = (219 - this.field_230712_o_.func_78256_a(dsp)) / 2;
        this.field_230712_o_.func_238421_b_(matrixStack, dsp, (float)offset, 165.0f, 0x404040);
        int sectionLength = 67;
        int x = 0;
        int y = 0;
        int xo = 9;
        int yo = 22;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 3 * this.rows;
        String dspToolTip = "";
        ArrayList<String> lineList = new ArrayList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        int offY = 23;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            IAEItemStack missingStack = this.missing.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                ++lines;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = Long.toString(stored.getStackSize());
                if (stored.getStackSize() >= 10000L) {
                    str = Long.toString(stored.getStackSize() / 1000L) + 'k';
                }
                if (stored.getStackSize() >= 10000000L) {
                    str = Long.toString(stored.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.FromStorage.getLocal() + ": " + str;
                int w2 = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w2 * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.FromStorage.getLocal() + ": " + Long.toString(stored.getStackSize()));
                }
                downY += 5;
            }
            boolean red = false;
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                String str = Long.toString(missingStack.getStackSize());
                if (missingStack.getStackSize() >= 10000L) {
                    str = Long.toString(missingStack.getStackSize() / 1000L) + 'k';
                }
                if (missingStack.getStackSize() >= 10000000L) {
                    str = Long.toString(missingStack.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.Missing.text().getString() + ": " + str;
                w = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Missing.getLocal() + ": " + Long.toString(missingStack.getStackSize()));
                }
                red = true;
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = Long.toString(pendingStack.getStackSize());
                if (pendingStack.getStackSize() >= 10000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000L) + 'k';
                }
                if (pendingStack.getStackSize() >= 10000000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.ToCraft.getLocal() + ": " + str;
                w = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.ToCraft.getLocal() + ": " + Long.toString(pendingStack.getStackSize()));
                }
            }
            RenderSystem.popMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.asItemStackRepresentation();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(refStack).getString();
                if (lineList.size() > 0) {
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
            }
            this.drawItem(posX, posY, is);
            if (red) {
                int startX = x * 68 + 9;
                int startY = posY - 4;
                CraftConfirmScreen.func_238467_a_((MatrixStack)matrixStack, (int)startX, (int)startY, (int)(startX + 67), (int)(startY + 23), (int)452919296);
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && !dspToolTip.isEmpty()) {
            this.drawTooltip(matrixStack, toolPosX, toolPosY + 10, (ITextComponent)new StringTextComponent(dspToolTip));
        }
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.setScrollBar();
        this.bindTexture("guis/craftingreport.png");
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.func_230927_p_());
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(114);
        this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.missing, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        IAEItemStack m = this.missing.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        if (m != null) {
            total += m.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode)) || keyCode != 257 && keyCode != 335)) {
            this.start();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Cpu", backwards ? "Prev" : "Next"));
    }

    private void start() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Start", "Start"));
    }
}

