/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.ItemRepo;
import appeng.client.me.SlotME;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class NetworkStatusScreen
extends AEBaseScreen<NetworkStatusContainer>
implements ISortSource {
    private final ItemRepo repo;
    private final int rows = 4;
    private int tooltip = -1;

    public NetworkStatusScreen(NetworkStatusContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.field_147000_g = 153;
        this.field_146999_f = 195;
        this.repo.setRowSize(5);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)CommonButtons.togglePowerUnit(this.field_147003_i - 18, this.field_147009_r + 8));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float btn) {
        int gx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int gy = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.tooltip = -1;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 14 + x * 31;
            int minY = gy + 41 + y * 18;
            if (minX < mouseX && minX + 28 > mouseX && minY < mouseY && minY + 20 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.NetworkDetails.getLocal(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.StoredPower.getLocal() + ": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_147002_h).getCurrentPower(), false), 13.0f, 16.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.MaxPower.getLocal() + ": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_147002_h).getMaxPower(), false), 13.0f, 26.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.PowerInputRate.getLocal() + ": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_147002_h).getAverageAddition(), true), 13.0f, 133.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.PowerUsageRate.getLocal() + ": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_147002_h).getPowerUsage(), true), 13.0f, 123.0f, 0x404040);
        int sectionLength = 30;
        int x = 0;
        int y = 0;
        int xo = 12;
        int yo = 42;
        boolean viewStart = false;
        int viewEnd = 20;
        String toolTip = "";
        int toolPosX = 0;
        int toolPosY = 0;
        for (int z = 0; z < Math.min(20, this.repo.size()); ++z) {
            IAEItemStack refStack = this.repo.getReferenceItem(z);
            if (refStack == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            String str = Long.toString(refStack.getStackSize());
            if (refStack.getStackSize() >= 10000L) {
                str = Long.toString(refStack.getStackSize() / 1000L) + 'k';
            }
            int w = this.field_230712_o_.func_78256_a(str);
            this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 30 + 12 + 30 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 18 + 42 + 6) * 2), 0x404040);
            RenderSystem.popMatrix();
            int posX = x * 30 + 12 + 30 - 18;
            int posY = y * 18 + 42;
            if (this.tooltip == z - 0) {
                toolTip = Platform.getItemDisplayName(refStack).getString();
                toolTip = toolTip + '\n' + GuiText.Installed.getLocal() + ": " + refStack.getStackSize();
                if (refStack.getCountRequestable() > 0L) {
                    toolTip = toolTip + '\n' + GuiText.EnergyDrain.getLocal() + ": " + Platform.formatPowerLong(refStack.getCountRequestable(), true);
                }
                toolPosX = x * 30 + 12 + 30 - 8;
                toolPosY = y * 18 + 42;
            }
            this.drawItem(posX, posY, refStack.asItemStackRepresentation());
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && toolTip.length() > 0) {
            this.drawTooltip(matrixStack, toolPosX, toolPosY + 10, (ITextComponent)new StringTextComponent(toolTip));
        }
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/networkstatus.png");
        GuiUtils.drawTexturedModalRect((int)offsetX, (int)offsetY, (int)0, (int)0, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.func_230927_p_());
    }

    public void postUpdate(List<IAEItemStack> list) {
        this.repo.clear();
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.repo.size();
        this.getScrollBar().setTop(39).setLeft(175).setHeight(78);
        this.getScrollBar().setRange(0, (size + 4) / 5 - this.rows, 1);
    }

    protected void func_230457_a_(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        Slot s = this.getSlot(x, y);
        if (s instanceof SlotME && !stack.func_190926_b()) {
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable theSlotField) {
                // empty catch block
            }
            if (myStack != null) {
                List currentToolTip = this.func_231151_a_(stack);
                while (currentToolTip.size() > 1) {
                    currentToolTip.remove(1);
                }
                currentToolTip.add(GuiText.Installed.withSuffix(": " + myStack.getStackSize()));
                currentToolTip.add(GuiText.EnergyDrain.withSuffix(": " + Platform.formatPowerLong(myStack.getCountRequestable(), true)));
                this.drawTooltip(matrixStack, x, y, currentToolTip);
            }
        }
        super.func_230457_a_(matrixStack, stack, x, y);
    }

    @Override
    public SortOrder getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public SortDir getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public ViewItems getSortDisplay() {
        return ViewItems.ALL;
    }
}

