/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.slot.AppEngSlot;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public class PatternTermScreen
extends MEMonitorableScreen<PatternTermContainer> {
    private static final String BACKGROUND_CRAFTING_MODE = "guis/pattern.png";
    private static final String BACKGROUND_PROCESSING_MODE = "guis/pattern2.png";
    private static final String SUBSITUTION_DISABLE = "0";
    private static final String SUBSITUTION_ENABLE = "1";
    private static final String CRAFTMODE_CRFTING = "1";
    private static final String CRAFTMODE_PROCESSING = "0";
    private TabButton tabCraftButton;
    private TabButton tabProcessButton;
    private ActionButton substitutionsEnabledBtn;
    private ActionButton substitutionsDisabledBtn;

    public PatternTermScreen(PatternTermContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.setReservedSpace(81);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.tabCraftButton = new TabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack((IItemProvider)Blocks.field_150462_ai), GuiText.CraftingPattern.text(), this.field_230707_j_, btn -> this.toggleCraftMode("0"));
        this.func_230480_a_((Widget)this.tabCraftButton);
        this.tabProcessButton = new TabButton(this.field_147003_i + 173, this.field_147009_r + this.field_147000_g - 177, new ItemStack((IItemProvider)Blocks.field_150460_al), GuiText.ProcessingPattern.text(), this.field_230707_j_, btn -> this.toggleCraftMode("1"));
        this.func_230480_a_((Widget)this.tabProcessButton);
        this.substitutionsEnabledBtn = new ActionButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, ActionItems.ENABLE_SUBSTITUTION, act -> this.toggleSubstitutions("0"));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.func_230480_a_((Widget)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(this.field_147003_i + 84, this.field_147009_r + this.field_147000_g - 163, ActionItems.DISABLE_SUBSTITUTION, act -> this.toggleSubstitutions("1"));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.func_230480_a_((Widget)this.substitutionsDisabledBtn);
        ActionButton clearBtn = new ActionButton(this.field_147003_i + 74, this.field_147009_r + this.field_147000_g - 163, ActionItems.CLOSE, act -> this.clear());
        clearBtn.setHalfSize(true);
        this.func_230480_a_((Widget)clearBtn);
        ActionButton encodeBtn = new ActionButton(this.field_147003_i + 147, this.field_147009_r + this.field_147000_g - 142, ActionItems.ENCODE, act -> this.encode());
        this.func_230480_a_((Widget)encodeBtn);
    }

    private void toggleCraftMode(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.CraftMode", mode));
    }

    private void toggleSubstitutions(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Substitute", mode));
    }

    private void encode() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Encode", "1"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Clear", "1"));
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (((PatternTermContainer)this.field_147002_h).isCraftingMode()) {
            this.tabCraftButton.field_230694_p_ = true;
            this.tabProcessButton.field_230694_p_ = false;
            if (((PatternTermContainer)this.field_147002_h).substitute) {
                this.substitutionsEnabledBtn.field_230694_p_ = true;
                this.substitutionsDisabledBtn.field_230694_p_ = false;
            } else {
                this.substitutionsEnabledBtn.field_230694_p_ = false;
                this.substitutionsDisabledBtn.field_230694_p_ = true;
            }
        } else {
            this.tabCraftButton.field_230694_p_ = false;
            this.tabProcessButton.field_230694_p_ = true;
            this.substitutionsEnabledBtn.field_230694_p_ = false;
            this.substitutionsDisabledBtn.field_230694_p_ = false;
        }
        super.drawFG(matrixStack, offsetX, offsetY, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.PatternTerminal.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 2 - this.getReservedSpace()), 0x404040);
    }

    @Override
    protected String getBackground() {
        if (((PatternTermContainer)this.field_147002_h).isCraftingMode()) {
            return BACKGROUND_CRAFTING_MODE;
        }
        return BACKGROUND_PROCESSING_MODE;
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        int offsetPlayerSide = s.isPlayerSide() ? 5 : 3;
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - offsetPlayerSide;
    }
}

