/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class AEModelData
implements IModelData {
    public static final ModelProperty<AEModelData> AEMODEL = new ModelProperty();
    public static final ModelProperty<Direction> UP = new ModelProperty();
    public static final ModelProperty<Direction> FORWARD = new ModelProperty();
    public static final ModelProperty<Boolean> CACHEABLE = new ModelProperty();
    private final Direction up;
    private final Direction forward;

    public AEModelData(Direction up, Direction forward) {
        this.up = (Direction)Preconditions.checkNotNull((Object)up);
        this.forward = (Direction)Preconditions.checkNotNull((Object)forward);
    }

    protected boolean isCacheable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEModelData that = (AEModelData)o;
        return this.up == that.up && this.forward == that.forward;
    }

    public int hashCode() {
        return Objects.hash(this.up, this.forward);
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        return prop == AEMODEL || prop == UP || prop == FORWARD || prop == CACHEABLE;
    }

    @Nullable
    public <T> T getData(ModelProperty<T> prop) {
        if (prop == AEMODEL) {
            return (T)this;
        }
        if (prop == UP) {
            return (T)this.up;
        }
        if (prop == FORWARD) {
            return (T)this.forward;
        }
        if (prop == CACHEABLE) {
            return (T)Boolean.valueOf(this.isCacheable());
        }
        return null;
    }

    @Nullable
    public <T> T setData(ModelProperty<T> prop, T data) {
        return null;
    }
}

