/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

final class RenderHelper {
    private static EnumMap<Direction, List<Vector3d>> cornersForFacing = RenderHelper.generateCornersForFacings();

    private RenderHelper() {
    }

    static List<Vector3d> getFaceCorners(Direction side) {
        return cornersForFacing.get(side);
    }

    private static EnumMap<Direction, List<Vector3d>> generateCornersForFacings() {
        EnumMap<Direction, List<Vector3d>> result = new EnumMap<Direction, List<Vector3d>>(Direction.class);
        for (Direction facing : Direction.values()) {
            List corners;
            float offset = facing.func_176743_c() == Direction.AxisDirection.NEGATIVE ? 0.0f : 1.0f;
            switch (facing.func_176740_k()) {
                default: {
                    corners = Lists.newArrayList((Object[])new Vector3d[]{new Vector3d((double)offset, 1.0, 1.0), new Vector3d((double)offset, 0.0, 1.0), new Vector3d((double)offset, 0.0, 0.0), new Vector3d((double)offset, 1.0, 0.0)});
                    break;
                }
                case Y: {
                    corners = Lists.newArrayList((Object[])new Vector3d[]{new Vector3d(1.0, (double)offset, 1.0), new Vector3d(1.0, (double)offset, 0.0), new Vector3d(0.0, (double)offset, 0.0), new Vector3d(0.0, (double)offset, 1.0)});
                    break;
                }
                case Z: {
                    corners = Lists.newArrayList((Object[])new Vector3d[]{new Vector3d(0.0, 1.0, (double)offset), new Vector3d(0.0, 0.0, (double)offset), new Vector3d(1.0, 0.0, (double)offset), new Vector3d(1.0, 1.0, (double)offset)});
                }
            }
            if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                corners = Lists.reverse((List)corners);
            }
            result.put(facing, (List<Vector3d>)ImmutableList.copyOf((Collection)corners));
        }
        return result;
    }

    private static Vector3d adjust(Vector3d vec, Direction.Axis axis, double delta) {
        switch (axis) {
            default: {
                return new Vector3d(vec.field_72450_a + delta, vec.field_72448_b, vec.field_72449_c);
            }
            case Y: {
                return new Vector3d(vec.field_72450_a, vec.field_72448_b + delta, vec.field_72449_c);
            }
            case Z: 
        }
        return new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c + delta);
    }
}

