/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerLocator;
import appeng.container.ContainerNull;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperInvItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class CraftingTermContainer
extends MEMonitorableContainer
implements IAEAppEngInventory,
IContainerCraftingPacket {
    public static ContainerType<CraftingTermContainer> TYPE;
    private static final ContainerHelper<CraftingTermContainer, ITerminalHost> helper;
    private final CraftingTerminalPart ct;
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 1);
    private final CraftingMatrixSlot[] craftingSlots = new CraftingMatrixSlot[9];
    private final CraftingTermSlot outputSlot;
    private IRecipe<CraftingInventory> currentRecipe;

    public static CraftingTermContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public CraftingTermContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        this.ct = (CraftingTerminalPart)monitorable;
        IItemHandler crafting = this.ct.getInventoryByName("crafting");
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                CraftingMatrixSlot craftingMatrixSlot = new CraftingMatrixSlot(this, crafting, x + y * 3, 37 + x * 18, -72 + y * 18);
                this.craftingSlots[x + y * 3] = craftingMatrixSlot;
                this.func_75146_a(craftingMatrixSlot);
            }
        }
        this.outputSlot = new CraftingTermSlot(this.getPlayerInv().field_70458_d, this.getActionSource(), this.getPowerSource(), monitorable, crafting, crafting, (IItemHandler)this.output, 131, -54, this);
        this.func_75146_a(this.outputSlot);
        this.bindPlayerInventory(ip, 0, 0);
        this.func_75130_a(new WrapperInvItemHandler(crafting));
    }

    public void func_75130_a(IInventory inventory) {
        ContainerNull cn = new ContainerNull();
        CraftingInventory ic = new CraftingInventory((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftingSlots[x].func_75211_c());
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)ic, this.getPlayerInv().field_70458_d.field_70170_p)) {
            World world = this.getPlayerInv().field_70458_d.field_70170_p;
            this.currentRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, world).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            ItemStack craftingResult = this.currentRecipe.func_77572_b((IInventory)ic);
            this.outputSlot.func_75215_d(craftingResult);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getPlayerInventory());
        }
        return this.ct.getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return true;
    }

    public IRecipe<CraftingInventory> getCurrentRecipe() {
        return this.currentRecipe;
    }

    static {
        helper = new ContainerHelper<CraftingTermContainer, ITerminalHost>(CraftingTermContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

