/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.MolecularAssemblerPatternSlot;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.tile.crafting.MolecularAssemblerTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class MolecularAssemblerContainer
extends UpgradeableContainer
implements IProgressProvider {
    public static ContainerType<MolecularAssemblerContainer> TYPE;
    private static final ContainerHelper<MolecularAssemblerContainer, MolecularAssemblerTileEntity> helper;
    private static final int MAX_CRAFT_PROGRESS = 100;
    private final MolecularAssemblerTileEntity tma;
    @GuiSync(value=4)
    public int craftProgress = 0;
    private Slot encodedPatternSlot;

    public static MolecularAssemblerContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public MolecularAssemblerContainer(int id, PlayerInventory ip, MolecularAssemblerTileEntity te) {
        super(TYPE, id, ip, te);
        this.tma = te;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack i) {
        IItemHandler mac = this.getUpgradeable().getInventoryByName("molecular_assembler");
        ItemStack is = mac.getStackInSlot(10);
        if (is.func_190926_b()) {
            return false;
        }
        if (is.func_77973_b() instanceof EncodedPatternItem) {
            World w = this.getTileEntity().func_145831_w();
            ICraftingPatternDetails ph = Api.instance().crafting().decodePattern(is, w);
            if (ph.isCraftable()) {
                return ph.isValidItemForSlot(slotIndex, i, w);
            }
        }
        return false;
    }

    @Override
    protected int getHeight() {
        return 197;
    }

    @Override
    protected void setupConfig() {
        int offX = 29;
        int offY = 30;
        IItemHandler mac = this.getUpgradeable().getInventoryByName("molecular_assembler");
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                MolecularAssemblerPatternSlot s = new MolecularAssemblerPatternSlot(this, mac, x + y * 3, offX + x * 18, offY + y * 18);
                this.func_75146_a(s);
            }
        }
        offX = 126;
        offY = 16;
        this.encodedPatternSlot = this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_CRAFTING_PATTERN, mac, 10, offX, offY, this.getPlayerInventory()));
        this.func_75146_a(new OutputSlot(mac, 9, offX, offY + 32, -1));
        offX = 122;
        offY = 17;
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 0, 187, 8, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 1, 187, 26, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 2, 187, 44, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 3, 187, 62, this.getPlayerInventory()).setNotDraggable());
        this.func_75146_a(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, upgrades, 4, 187, 80, this.getPlayerInventory()).setNotDraggable());
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.setRedStoneMode((RedstoneMode)this.getUpgradeable().getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED));
        }
        this.craftProgress = this.tma.getCraftingProgress();
        this.standardDetectAndSendChanges();
    }

    @Override
    public int getCurrentProgress() {
        return this.craftProgress;
    }

    @Override
    public int getMaxProgress() {
        return 100;
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot) {
            for (Slot otherSlot : this.field_75151_b) {
                if (otherSlot == s || !(otherSlot instanceof AppEngSlot)) continue;
                ((AppEngSlot)otherSlot).setIsValid(AppEngSlot.CalculatedValidity.NotAvailable);
            }
        }
    }

    static {
        helper = new ContainerHelper<MolecularAssemblerContainer, MolecularAssemblerTileEntity>(MolecularAssemblerContainer::new, MolecularAssemblerTileEntity.class);
    }
}

