/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.parts.IPart;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.helpers.IPriorityHost;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class PriorityContainer
extends AEBaseContainer {
    public static ContainerType<PriorityContainer> TYPE;
    private static final ContainerHelper<PriorityContainer, IPriorityHost> helper;
    private final IPriorityHost priHost;
    private int priorityValue;

    public static PriorityContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf, (host, container, buffer) -> {
            container.priorityValue = buffer.func_150792_a();
        });
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator, (host, buffer) -> buffer.func_150787_b(host.getPriority()));
    }

    public PriorityContainer(int id, PlayerInventory ip, IPriorityHost te) {
        super(TYPE, id, ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)((Object)(te instanceof IPart ? te : null)));
        this.priHost = te;
        this.priorityValue = te.getPriority();
    }

    public void setPriority(int newValue) {
        if (newValue != this.priorityValue) {
            if (this.isClient()) {
                this.priorityValue = newValue;
                NetworkHandler.instance().sendToServer(new ConfigValuePacket("PriorityHost.Priority", String.valueOf(newValue)));
            } else {
                this.priHost.setPriority(newValue);
                this.priorityValue = newValue;
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public int getPriorityValue() {
        return this.priorityValue;
    }

    public IPriorityHost getPriorityHost() {
        return this.priHost;
    }

    static {
        helper = new ContainerHelper<PriorityContainer, IPriorityHost>(PriorityContainer::new, IPriorityHost.class, SecurityPermissions.BUILD);
    }
}

