/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.AEConfig;
import appeng.tile.networking.WirelessTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;

public class WirelessContainer
extends AEBaseContainer {
    public static ContainerType<WirelessContainer> TYPE;
    private static final ContainerHelper<WirelessContainer, WirelessTileEntity> helper;
    private final RestrictedInputSlot boosterSlot;
    @GuiSync(value=1)
    public long range = 0L;
    @GuiSync(value=2)
    public long drain = 0L;

    public static WirelessContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public WirelessContainer(int id, PlayerInventory ip, WirelessTileEntity te) {
        super(TYPE, id, ip, te, null);
        this.boosterSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.RANGE_BOOSTER, te.getInternalInventory(), 0, 80, 47, this.getPlayerInventory());
        this.func_75146_a(this.boosterSlot);
        this.bindPlayerInventory(ip, 0, 84);
    }

    @Override
    public void func_75142_b() {
        int boosters = this.boosterSlot.func_75211_c().func_190926_b() ? 0 : this.boosterSlot.func_75211_c().func_190916_E();
        this.setRange((long)(10.0 * AEConfig.instance().wireless_getMaxRange(boosters)));
        this.setDrain((long)(100.0 * AEConfig.instance().wireless_getPowerDrain(boosters)));
        super.func_75142_b();
    }

    public long getRange() {
        return this.range;
    }

    private void setRange(long range) {
        this.range = range;
    }

    public long getDrain() {
        return this.drain;
    }

    private void setDrain(long drain) {
        this.drain = drain;
    }

    static {
        helper = new ContainerHelper<WirelessContainer, WirelessTileEntity>(WirelessContainer::new, WirelessTileEntity.class, SecurityPermissions.BUILD);
    }
}

