/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.features.INetworkEncodable;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.container.slot.AppEngSlot;
import appeng.core.Api;
import appeng.items.misc.EncodedPatternItem;
import appeng.recipes.handlers.GrinderRecipes;
import appeng.tile.misc.InscriberRecipes;
import appeng.util.Platform;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public class RestrictedInputSlot
extends AppEngSlot {
    private static final List<ResourceLocation> METAL_INGOT_TAGS = ImmutableList.of((Object)new ResourceLocation("forge:ingots/copper"), (Object)new ResourceLocation("forge:ingots/tin"), (Object)new ResourceLocation("forge:ingots/iron"), (Object)new ResourceLocation("forge:ingots/gold"), (Object)new ResourceLocation("forge:ingots/lead"), (Object)new ResourceLocation("forge:ingots/bronze"), (Object)new ResourceLocation("forge:ingots/brass"), (Object)new ResourceLocation("forge:ingots/nickel"), (Object)new ResourceLocation("forge:ingots/aluminium"));
    private final PlacableItemType which;
    private final PlayerInventory p;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public RestrictedInputSlot(PlacableItemType valid, IItemHandler inv, int invSlot, int x, int y, PlayerInventory p) {
        super(inv, invSlot, x, y);
        this.which = valid;
        this.setIIcon(valid.IIcon);
        this.p = p;
    }

    @Override
    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.func_75219_a();
    }

    public boolean isValid(ItemStack is, World theWorld) {
        if (this.which == PlacableItemType.VALID_ENCODED_PATTERN_W_OUTPUT) {
            return Api.instance().crafting().decodePattern(is, theWorld) != null;
        }
        return true;
    }

    public Slot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
        if (!this.getContainer().isValidForSlot(this, stack)) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (!super.func_75214_a(stack)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        IMaterials materials = definitions.materials();
        IItems items = definitions.items();
        ICraftingHelper crafting = Api.instance().crafting();
        switch (this.which) {
            case ENCODED_CRAFTING_PATTERN: {
                ICraftingPatternDetails de = crafting.decodePattern(stack, this.p.field_70458_d.field_70170_p);
                if (de != null) {
                    return de.isCraftable();
                }
                return false;
            }
            case VALID_ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN_W_OUTPUT: 
            case ENCODED_PATTERN: {
                return crafting.isEncodedPattern(stack);
            }
            case BLANK_PATTERN: {
                return materials.blankPattern().isSameAs(stack);
            }
            case PATTERN: {
                return materials.blankPattern().isSameAs(stack) || crafting.isEncodedPattern(stack);
            }
            case INSCRIBER_PLATE: {
                if (materials.namePress().isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(this.p.field_70458_d.field_70170_p, stack);
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return RestrictedInputSlot.isMetalIngot(stack);
            }
            case VIEW_CELL: {
                return items.viewCell().isSameAs(stack);
            }
            case ORE: {
                return GrinderRecipes.isValidIngredient(this.p.field_70458_d.field_70170_p, stack);
            }
            case FUEL: {
                return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(stack);
            }
            case QE_SINGULARITY: {
                return materials.qESingularity().isSameAs(stack);
            }
            case RANGE_BOOSTER: {
                return materials.wirelessBooster().isSameAs(stack);
            }
            case SPATIAL_STORAGE_CELLS: {
                return stack.func_77973_b() instanceof ISpatialStorageCell && ((ISpatialStorageCell)stack.func_77973_b()).isSpatialStorage(stack);
            }
            case STORAGE_CELLS: {
                return Api.instance().registries().cell().isCellHandled(stack);
            }
            case WORKBENCH_CELL: {
                return stack.func_77973_b() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)stack.func_77973_b()).isEditable(stack);
            }
            case STORAGE_COMPONENT: {
                return stack.func_77973_b() instanceof IStorageComponent && ((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack);
            }
            case TRASH: {
                if (Api.instance().registries().cell().isCellHandled(stack)) {
                    return false;
                }
                return !(stack.func_77973_b() instanceof IStorageComponent) || !((IStorageComponent)stack.func_77973_b()).isStorageComponent(stack);
            }
            case ENCODABLE_ITEM: {
                return stack.func_77973_b() instanceof INetworkEncodable || Api.instance().registries().wireless().isWirelessTerminal(stack);
            }
            case BIOMETRIC_CARD: {
                return stack.func_77973_b() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return stack.func_77973_b() instanceof IUpgradeModule && ((IUpgradeModule)stack.func_77973_b()).getType(stack) != null;
            }
        }
        return false;
    }

    @Override
    public boolean func_82869_a(PlayerEntity player) {
        return this.isAllowEdit();
    }

    @Override
    public ItemStack getDisplayStack() {
        EncodedPatternItem iep;
        ItemStack out;
        ItemStack is;
        if (Platform.isClient() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.func_75211_c()).func_190926_b() && is.func_77973_b() instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)is.func_77973_b()).getOutput(is)).func_190926_b()) {
            return out;
        }
        return super.func_75211_c();
    }

    public static boolean isMetalIngot(ItemStack i) {
        if (Platform.itemComparisons().isSameItem(i, new ItemStack((IItemProvider)Items.field_151042_j))) {
            return true;
        }
        Set itemTags = i.func_77973_b().getTags();
        for (ResourceLocation tagName : METAL_INGOT_TAGS) {
            if (!itemTags.contains(tagName)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(15),
        ORE(31),
        STORAGE_COMPONENT(63),
        ENCODABLE_ITEM(79),
        TRASH(95),
        VALID_ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_PATTERN_W_OUTPUT(127),
        ENCODED_CRAFTING_PATTERN(127),
        ENCODED_PATTERN(127),
        PATTERN(143),
        BLANK_PATTERN(143),
        POWERED_TOOL(159),
        RANGE_BOOSTER(111),
        QE_SINGULARITY(175),
        SPATIAL_STORAGE_CELLS(191),
        FUEL(207),
        UPGRADES(223),
        WORKBENCH_CELL(15),
        BIOMETRIC_CARD(239),
        VIEW_CELL(78),
        INSCRIBER_PLATE(46),
        INSCRIBER_INPUT(62),
        METAL_INGOTS(62);

        public final int IIcon;

        private PlacableItemType(int o) {
            this.IIcon = o;
        }
    }
}

