/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.Upgrades;
import appeng.api.features.AEFeature;
import appeng.api.features.IRegistryContainer;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWorldGen;
import appeng.api.movable.IMovableRegistry;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.block.paint.PaintSplotchesModel;
import appeng.block.qnb.QnbFormedModel;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IClientSetupComponent;
import appeng.bootstrap.components.IEntityRegistrationComponent;
import appeng.bootstrap.components.IItemColorRegistrationComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IModelBakeComponent;
import appeng.bootstrap.components.ITileEntityRegistrationComponent;
import appeng.client.gui.implementations.CellWorkbenchScreen;
import appeng.client.gui.implementations.ChestScreen;
import appeng.client.gui.implementations.CondenserScreen;
import appeng.client.gui.implementations.CraftAmountScreen;
import appeng.client.gui.implementations.CraftConfirmScreen;
import appeng.client.gui.implementations.CraftingCPUScreen;
import appeng.client.gui.implementations.CraftingStatusScreen;
import appeng.client.gui.implementations.CraftingTermScreen;
import appeng.client.gui.implementations.DriveScreen;
import appeng.client.gui.implementations.FormationPlaneScreen;
import appeng.client.gui.implementations.GrinderScreen;
import appeng.client.gui.implementations.IOPortScreen;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.InterfaceTerminalScreen;
import appeng.client.gui.implementations.LevelEmitterScreen;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.implementations.MEPortableCellScreen;
import appeng.client.gui.implementations.MolecularAssemblerScreen;
import appeng.client.gui.implementations.NetworkStatusScreen;
import appeng.client.gui.implementations.NetworkToolScreen;
import appeng.client.gui.implementations.PatternTermScreen;
import appeng.client.gui.implementations.PriorityScreen;
import appeng.client.gui.implementations.QNBScreen;
import appeng.client.gui.implementations.QuartzKnifeScreen;
import appeng.client.gui.implementations.SecurityStationScreen;
import appeng.client.gui.implementations.SkyChestScreen;
import appeng.client.gui.implementations.SpatialAnchorScreen;
import appeng.client.gui.implementations.SpatialIOPortScreen;
import appeng.client.gui.implementations.StorageBusScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.implementations.VibrationChamberScreen;
import appeng.client.gui.implementations.WirelessScreen;
import appeng.client.gui.implementations.WirelessTermScreen;
import appeng.client.render.DummyFluidItemModel;
import appeng.client.render.FacadeItemModel;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.cablebus.CableBusModelLoader;
import appeng.client.render.cablebus.P2PTunnelFrequencyModel;
import appeng.client.render.crafting.CraftingCubeModelLoader;
import appeng.client.render.crafting.EncodedPatternModelLoader;
import appeng.client.render.effects.ChargedOreFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.MatterCannonFX;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.effects.VibrantFX;
import appeng.client.render.model.BiometricCardModel;
import appeng.client.render.model.ColorApplicatorModel;
import appeng.client.render.model.DriveModel;
import appeng.client.render.model.GlassModel;
import appeng.client.render.model.MemoryCardModel;
import appeng.client.render.model.SkyCompassModel;
import appeng.client.render.spatial.SpatialPylonModel;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.tesr.SkyChestTESR;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CellWorkbenchContainer;
import appeng.container.implementations.ChestContainer;
import appeng.container.implementations.CondenserContainer;
import appeng.container.implementations.CraftAmountContainer;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.container.implementations.CraftingStatusContainer;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.DriveContainer;
import appeng.container.implementations.FormationPlaneContainer;
import appeng.container.implementations.GrinderContainer;
import appeng.container.implementations.IOPortContainer;
import appeng.container.implementations.InscriberContainer;
import appeng.container.implementations.InterfaceContainer;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.MEPortableCellContainer;
import appeng.container.implementations.MolecularAssemblerContainer;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.container.implementations.NetworkToolContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.PriorityContainer;
import appeng.container.implementations.QNBContainer;
import appeng.container.implementations.QuartzKnifeContainer;
import appeng.container.implementations.SecurityStationContainer;
import appeng.container.implementations.SkyChestContainer;
import appeng.container.implementations.SpatialAnchorContainer;
import appeng.container.implementations.SpatialIOPortContainer;
import appeng.container.implementations.StorageBusContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.implementations.VibrationChamberContainer;
import appeng.container.implementations.WirelessContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.AppEng;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiItems;
import appeng.core.api.definitions.ApiParts;
import appeng.core.features.registries.P2PTunnelRegistry;
import appeng.core.features.registries.PartModels;
import appeng.core.features.registries.cell.BasicCellHandler;
import appeng.core.features.registries.cell.BasicItemCellGuiHandler;
import appeng.core.features.registries.cell.CreativeCellHandler;
import appeng.core.localization.GuiText;
import appeng.core.stats.AdvancementTriggers;
import appeng.core.stats.AeStats;
import appeng.fluids.client.gui.FluidFormationPlaneScreen;
import appeng.fluids.client.gui.FluidIOScreen;
import appeng.fluids.client.gui.FluidInterfaceScreen;
import appeng.fluids.client.gui.FluidLevelEmitterScreen;
import appeng.fluids.client.gui.FluidStorageBusScreen;
import appeng.fluids.client.gui.FluidTerminalScreen;
import appeng.fluids.container.FluidFormationPlaneContainer;
import appeng.fluids.container.FluidIOContainer;
import appeng.fluids.container.FluidInterfaceContainer;
import appeng.fluids.container.FluidLevelEmitterContainer;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.fluids.registries.BasicFluidCellGuiHandler;
import appeng.items.parts.FacadeItem;
import appeng.me.cache.CraftingGridCache;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.GridStorageCache;
import appeng.me.cache.P2PCache;
import appeng.me.cache.PathGridCache;
import appeng.me.cache.SecurityCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.cache.StatisticsCache;
import appeng.me.cache.TickManagerCache;
import appeng.mixins.feature.ConfiguredFeaturesAccessor;
import appeng.mixins.structure.ConfiguredStructureFeaturesAccessor;
import appeng.parts.automation.PlaneModelLoader;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.game.DisassembleRecipe;
import appeng.recipes.game.FacadeRecipe;
import appeng.recipes.handlers.GrinderRecipeSerializer;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import appeng.server.AECommand;
import appeng.spatial.SpatialStorageBiome;
import appeng.spatial.SpatialStorageChunkGenerator;
import appeng.spatial.SpatialStorageDimensionIds;
import appeng.tile.AEBaseTileEntity;
import appeng.tile.crafting.MolecularAssemblerRenderer;
import appeng.worldgen.ChargedQuartzOreConfig;
import appeng.worldgen.ChargedQuartzOreFeature;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.DaylightDetectorTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

final class Registration {
    static AdvancementTriggers advancementTriggers;
    private static ConfiguredFeature<?, ?> quartzOreFeature;
    private static ConfiguredFeature<?, ?> chargedQuartzOreFeature;

    Registration() {
    }

    public static void setupInternalRegistries() {
        Api api = Api.INSTANCE;
        IRegistryContainer registries = api.registries();
        IGridCacheRegistry gcr = registries.gridCache();
        gcr.registerGridCache(ITickManager.class, TickManagerCache::new);
        gcr.registerGridCache(IEnergyGrid.class, EnergyGridCache::new);
        gcr.registerGridCache(IPathingGrid.class, PathGridCache::new);
        gcr.registerGridCache(IStorageGrid.class, GridStorageCache::new);
        gcr.registerGridCache(P2PCache.class, P2PCache::new);
        gcr.registerGridCache(ISpatialCache.class, SpatialPylonCache::new);
        gcr.registerGridCache(ISecurityGrid.class, SecurityCache::new);
        gcr.registerGridCache(ICraftingGrid.class, CraftingGridCache::new);
        gcr.registerGridCache(StatisticsCache.class, StatisticsCache::new);
        registries.cell().addCellHandler(new BasicCellHandler());
        registries.cell().addCellHandler(new CreativeCellHandler());
        registries.cell().addCellGuiHandler(new BasicItemCellGuiHandler());
        registries.cell().addCellGuiHandler(new BasicFluidCellGuiHandler());
        registries.matterCannon().registerAmmoItem(api.definitions().materials().matterBall().item(), 32.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistryEvent(ModelRegistryEvent event) {
        this.registerSpecialModels();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IClientSetupComponent.class).forEachRemaining(IClientSetupComponent::setup);
        Registration.addBuiltInModel("glass", GlassModel::new);
        Registration.addBuiltInModel("sky_compass", SkyCompassModel::new);
        Registration.addBuiltInModel("dummy_fluid_item", DummyFluidItemModel::new);
        Registration.addBuiltInModel("memory_card", MemoryCardModel::new);
        Registration.addBuiltInModel("biometric_card", BiometricCardModel::new);
        Registration.addBuiltInModel("drive", DriveModel::new);
        Registration.addBuiltInModel("color_applicator", ColorApplicatorModel::new);
        Registration.addBuiltInModel("spatial_pylon", SpatialPylonModel::new);
        Registration.addBuiltInModel("paint_splotches", PaintSplotchesModel::new);
        Registration.addBuiltInModel("quantum_bridge_formed", QnbFormedModel::new);
        Registration.addBuiltInModel("p2p_tunnel_frequency", P2PTunnelFrequencyModel::new);
        Registration.addBuiltInModel("facade", FacadeItemModel::new);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("appliedenergistics2", "encoded_pattern"), (IModelLoader)EncodedPatternModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("appliedenergistics2", "part_plane"), (IModelLoader)PlaneModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("appliedenergistics2", "crafting_cube"), (IModelLoader)CraftingCubeModelLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("appliedenergistics2", "cable_bus"), (IModelLoader)new CableBusModelLoader((PartModels)Api.INSTANCE.registries().partModels()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends IModelGeometry<T>> void addBuiltInModel(String id, Supplier<T> modelFactory) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("appliedenergistics2", id), new SimpleModelLoader<T>(modelFactory));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerSpecialModels() {
        ModelLoader.addSpecialModel((ResourceLocation)MolecularAssemblerRenderer.LIGHTS_MODEL);
        PartModels partModels = (PartModels)Api.INSTANCE.registries().partModels();
        partModels.getModels().forEach(ModelLoader::addSpecialModel);
        partModels.setInitialized(true);
    }

    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        Biome biome = SpatialStorageBiome.INSTANCE;
        biome.setRegistryName(SpatialStorageDimensionIds.BIOME_KEY.func_240901_a_());
        event.getRegistry().register((IForgeRegistryEntry)biome);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        Dist dist = FMLEnvironment.dist;
        definitions.getRegistry().getBootstrapComponents(IBlockRegistrationComponent.class).forEachRemaining(b -> b.blockRegistration(dist, (IForgeRegistry<Block>)registry));
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        Dist dist = FMLEnvironment.dist;
        definitions.getRegistry().getBootstrapComponents(IItemRegistrationComponent.class).forEachRemaining(b -> b.itemRegistration(dist, (IForgeRegistry<Item>)registry));
    }

    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(ITileEntityRegistrationComponent.class).forEachRemaining(b -> b.register(registry));
    }

    public void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        CellWorkbenchContainer.TYPE = this.registerContainer(registry, "cellworkbench", CellWorkbenchContainer::fromNetwork, CellWorkbenchContainer::open);
        ChestContainer.TYPE = this.registerContainer(registry, "chest", ChestContainer::fromNetwork, ChestContainer::open);
        CondenserContainer.TYPE = this.registerContainer(registry, "condenser", CondenserContainer::fromNetwork, CondenserContainer::open);
        CraftAmountContainer.TYPE = this.registerContainer(registry, "craftamount", CraftAmountContainer::fromNetwork, CraftAmountContainer::open);
        CraftConfirmContainer.TYPE = this.registerContainer(registry, "craftconfirm", CraftConfirmContainer::fromNetwork, CraftConfirmContainer::open);
        CraftingCPUContainer.TYPE = this.registerContainer(registry, "craftingcpu", CraftingCPUContainer::fromNetwork, CraftingCPUContainer::open);
        CraftingStatusContainer.TYPE = this.registerContainer(registry, "craftingstatus", CraftingStatusContainer::fromNetwork, CraftingStatusContainer::open);
        CraftingTermContainer.TYPE = this.registerContainer(registry, "craftingterm", CraftingTermContainer::fromNetwork, CraftingTermContainer::open);
        DriveContainer.TYPE = this.registerContainer(registry, "drive", DriveContainer::fromNetwork, DriveContainer::open);
        FormationPlaneContainer.TYPE = this.registerContainer(registry, "formationplane", FormationPlaneContainer::fromNetwork, FormationPlaneContainer::open);
        GrinderContainer.TYPE = this.registerContainer(registry, "grinder", GrinderContainer::fromNetwork, GrinderContainer::open);
        InscriberContainer.TYPE = this.registerContainer(registry, "inscriber", InscriberContainer::fromNetwork, InscriberContainer::open);
        InterfaceContainer.TYPE = this.registerContainer(registry, "interface", InterfaceContainer::fromNetwork, InterfaceContainer::open);
        InterfaceTerminalContainer.TYPE = this.registerContainer(registry, "interfaceterminal", InterfaceTerminalContainer::fromNetwork, InterfaceTerminalContainer::open);
        IOPortContainer.TYPE = this.registerContainer(registry, "ioport", IOPortContainer::fromNetwork, IOPortContainer::open);
        LevelEmitterContainer.TYPE = this.registerContainer(registry, "levelemitter", LevelEmitterContainer::fromNetwork, LevelEmitterContainer::open);
        MolecularAssemblerContainer.TYPE = this.registerContainer(registry, "molecular_assembler", MolecularAssemblerContainer::fromNetwork, MolecularAssemblerContainer::open);
        MEMonitorableContainer.TYPE = this.registerContainer(registry, "memonitorable", MEMonitorableContainer::fromNetwork, MEMonitorableContainer::open);
        MEPortableCellContainer.TYPE = this.registerContainer(registry, "meportablecell", MEPortableCellContainer::fromNetwork, MEPortableCellContainer::open);
        NetworkStatusContainer.TYPE = this.registerContainer(registry, "networkstatus", NetworkStatusContainer::fromNetwork, NetworkStatusContainer::open);
        NetworkToolContainer.TYPE = this.registerContainer(registry, "networktool", NetworkToolContainer::fromNetwork, NetworkToolContainer::open);
        PatternTermContainer.TYPE = this.registerContainer(registry, "patternterm", PatternTermContainer::fromNetwork, PatternTermContainer::open);
        PriorityContainer.TYPE = this.registerContainer(registry, "priority", PriorityContainer::fromNetwork, PriorityContainer::open);
        QNBContainer.TYPE = this.registerContainer(registry, "qnb", QNBContainer::fromNetwork, QNBContainer::open);
        QuartzKnifeContainer.TYPE = this.registerContainer(registry, "quartzknife", QuartzKnifeContainer::fromNetwork, QuartzKnifeContainer::open);
        SecurityStationContainer.TYPE = this.registerContainer(registry, "securitystation", SecurityStationContainer::fromNetwork, SecurityStationContainer::open);
        SkyChestContainer.TYPE = this.registerContainer(registry, "skychest", SkyChestContainer::fromNetwork, SkyChestContainer::open);
        SpatialIOPortContainer.TYPE = this.registerContainer(registry, "spatialioport", SpatialIOPortContainer::fromNetwork, SpatialIOPortContainer::open);
        SpatialAnchorContainer.TYPE = this.registerContainer(registry, "spatialanchor", SpatialAnchorContainer::fromNetwork, SpatialAnchorContainer::open);
        StorageBusContainer.TYPE = this.registerContainer(registry, "storagebus", StorageBusContainer::fromNetwork, StorageBusContainer::open);
        UpgradeableContainer.TYPE = this.registerContainer(registry, "upgradeable", UpgradeableContainer::fromNetwork, UpgradeableContainer::open);
        VibrationChamberContainer.TYPE = this.registerContainer(registry, "vibrationchamber", VibrationChamberContainer::fromNetwork, VibrationChamberContainer::open);
        WirelessContainer.TYPE = this.registerContainer(registry, "wireless", WirelessContainer::fromNetwork, WirelessContainer::open);
        WirelessTermContainer.TYPE = this.registerContainer(registry, "wirelessterm", WirelessTermContainer::fromNetwork, WirelessTermContainer::open);
        FluidFormationPlaneContainer.TYPE = this.registerContainer(registry, "fluid_formation_plane", FluidFormationPlaneContainer::fromNetwork, FluidFormationPlaneContainer::open);
        FluidIOContainer.TYPE = this.registerContainer(registry, "fluid_io", FluidIOContainer::fromNetwork, FluidIOContainer::open);
        FluidInterfaceContainer.TYPE = this.registerContainer(registry, "fluid_interface", FluidInterfaceContainer::fromNetwork, FluidInterfaceContainer::open);
        FluidLevelEmitterContainer.TYPE = this.registerContainer(registry, "fluid_level_emitter", FluidLevelEmitterContainer::fromNetwork, FluidLevelEmitterContainer::open);
        FluidStorageBusContainer.TYPE = this.registerContainer(registry, "fluid_storage_bus", FluidStorageBusContainer::fromNetwork, FluidStorageBusContainer::open);
        FluidTerminalContainer.TYPE = this.registerContainer(registry, "fluid_terminal", FluidTerminalContainer::fromNetwork, FluidTerminalContainer::open);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenManager.func_216911_a(GrinderContainer.TYPE, GrinderScreen::new);
            ScreenManager.func_216911_a(QNBContainer.TYPE, QNBScreen::new);
            ScreenManager.func_216911_a(SkyChestContainer.TYPE, SkyChestScreen::new);
            ScreenManager.func_216911_a(ChestContainer.TYPE, ChestScreen::new);
            ScreenManager.func_216911_a(WirelessContainer.TYPE, WirelessScreen::new);
            ScreenManager.func_216911_a(MEMonitorableContainer.TYPE, MEMonitorableScreen::new);
            ScreenManager.func_216911_a(MEPortableCellContainer.TYPE, MEPortableCellScreen::new);
            ScreenManager.func_216911_a(WirelessTermContainer.TYPE, WirelessTermScreen::new);
            ScreenManager.func_216911_a(NetworkStatusContainer.TYPE, NetworkStatusScreen::new);
            ScreenManager.func_216911_a(CraftingCPUContainer.TYPE, CraftingCPUScreen::new);
            ScreenManager.func_216911_a(NetworkToolContainer.TYPE, NetworkToolScreen::new);
            ScreenManager.func_216911_a(QuartzKnifeContainer.TYPE, QuartzKnifeScreen::new);
            ScreenManager.func_216911_a(DriveContainer.TYPE, DriveScreen::new);
            ScreenManager.func_216911_a(VibrationChamberContainer.TYPE, VibrationChamberScreen::new);
            ScreenManager.func_216911_a(CondenserContainer.TYPE, CondenserScreen::new);
            ScreenManager.func_216911_a(InterfaceContainer.TYPE, InterfaceScreen::new);
            ScreenManager.func_216911_a(FluidInterfaceContainer.TYPE, FluidInterfaceScreen::new);
            ScreenManager.func_216911_a(UpgradeableContainer.TYPE, UpgradeableScreen::new);
            ScreenManager.func_216911_a(FluidIOContainer.TYPE, FluidIOScreen::new);
            ScreenManager.func_216911_a(IOPortContainer.TYPE, IOPortScreen::new);
            ScreenManager.func_216911_a(StorageBusContainer.TYPE, StorageBusScreen::new);
            ScreenManager.func_216911_a(FluidStorageBusContainer.TYPE, FluidStorageBusScreen::new);
            ScreenManager.func_216911_a(FormationPlaneContainer.TYPE, FormationPlaneScreen::new);
            ScreenManager.func_216911_a(FluidFormationPlaneContainer.TYPE, FluidFormationPlaneScreen::new);
            ScreenManager.func_216911_a(PriorityContainer.TYPE, PriorityScreen::new);
            ScreenManager.func_216911_a(SecurityStationContainer.TYPE, SecurityStationScreen::new);
            ScreenManager.func_216911_a(CraftingTermContainer.TYPE, CraftingTermScreen::new);
            ScreenManager.func_216911_a(PatternTermContainer.TYPE, PatternTermScreen::new);
            ScreenManager.func_216911_a(FluidTerminalContainer.TYPE, FluidTerminalScreen::new);
            ScreenManager.func_216911_a(LevelEmitterContainer.TYPE, LevelEmitterScreen::new);
            ScreenManager.func_216911_a(FluidLevelEmitterContainer.TYPE, FluidLevelEmitterScreen::new);
            ScreenManager.func_216911_a(SpatialIOPortContainer.TYPE, SpatialIOPortScreen::new);
            ScreenManager.func_216911_a(InscriberContainer.TYPE, InscriberScreen::new);
            ScreenManager.func_216911_a(CellWorkbenchContainer.TYPE, CellWorkbenchScreen::new);
            ScreenManager.func_216911_a(MolecularAssemblerContainer.TYPE, MolecularAssemblerScreen::new);
            ScreenManager.func_216911_a(CraftAmountContainer.TYPE, CraftAmountScreen::new);
            ScreenManager.func_216911_a(CraftConfirmContainer.TYPE, CraftConfirmScreen::new);
            ScreenManager.func_216911_a(InterfaceTerminalContainer.TYPE, InterfaceTerminalScreen::new);
            ScreenManager.func_216911_a(CraftingStatusContainer.TYPE, CraftingStatusScreen::new);
            ScreenManager.func_216911_a(SpatialAnchorContainer.TYPE, SpatialAnchorScreen::new);
        });
    }

    private <T extends AEBaseContainer> ContainerType<T> registerContainer(IForgeRegistry<ContainerType<?>> registry, String id, IContainerFactory<T> factory, ContainerOpener.Opener<T> opener) {
        ContainerType type = IForgeContainerType.create(factory);
        type.setRegistryName("appliedenergistics2", id);
        registry.register((IForgeRegistryEntry)type);
        ContainerOpener.addOpener(type, opener);
        return type;
    }

    public void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry r = event.getRegistry();
        FacadeItem facadeItem = (FacadeItem)Api.INSTANCE.definitions().items().facade().item();
        r.registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{DisassembleRecipe.SERIALIZER, GrinderRecipeSerializer.INSTANCE, InscriberRecipeSerializer.INSTANCE, FacadeRecipe.getSerializer(facadeItem), EntropyRecipeSerializer.INSTANCE});
    }

    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IEntityRegistrationComponent.class).forEachRemaining(b -> b.entityRegistration(registry));
    }

    public void registerParticleTypes(RegistryEvent.Register<ParticleType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ParticleTypes.CHARGED_ORE);
        registry.register((IForgeRegistryEntry)ParticleTypes.CRAFTING);
        registry.register(ParticleTypes.ENERGY);
        registry.register(ParticleTypes.LIGHTNING_ARC);
        registry.register((IForgeRegistryEntry)ParticleTypes.LIGHTNING);
        registry.register((IForgeRegistryEntry)ParticleTypes.MATTER_CANNON);
        registry.register((IForgeRegistryEntry)ParticleTypes.VIBRANT);
    }

    public void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        MeteoriteStructurePiece.register();
        Registration.registerStructure(event.getRegistry(), MeteoriteStructure.ID.toString(), MeteoriteStructure.INSTANCE, GenerationStage.Decoration.TOP_LAYER_MODIFICATION);
        ConfiguredStructureFeaturesAccessor.register(MeteoriteStructure.ID.toString(), MeteoriteStructure.CONFIGURED_INSTANCE);
    }

    private static <F extends Structure<?>> void registerStructure(IForgeRegistry<Structure<?>> registry, String name, F structure, GenerationStage.Decoration stage) {
        Structure.field_236365_a_.put((Object)name.toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, stage);
        structure.setRegistryName(name.toLowerCase(Locale.ROOT));
        registry.register(structure);
    }

    public void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ChargedQuartzOreFeature.INSTANCE.setRegistryName(AppEng.makeId("charged_quartz_ore"));
        registry.register((IForgeRegistryEntry)ChargedQuartzOreFeature.INSTANCE);
        quartzOreFeature = Registration.registerQuartzOreFeature();
        chargedQuartzOreFeature = Registration.registerChargedQuartzOreFeature();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleManager particles = Minecraft.func_71410_x().field_71452_i;
        particles.func_215234_a((ParticleType)ParticleTypes.CHARGED_ORE, ChargedOreFX.Factory::new);
        particles.func_215234_a((ParticleType)ParticleTypes.CRAFTING, CraftingFx.Factory::new);
        particles.func_215234_a(ParticleTypes.ENERGY, EnergyFx.Factory::new);
        particles.func_215234_a(ParticleTypes.LIGHTNING_ARC, LightningArcFX.Factory::new);
        particles.func_215234_a((ParticleType)ParticleTypes.LIGHTNING, LightningFX.Factory::new);
        particles.func_215234_a((ParticleType)ParticleTypes.MATTER_CANNON, MatterCannonFX.Factory::new);
        particles.func_215234_a((ParticleType)ParticleTypes.VIBRANT, VibrantFX.Factory::new);
    }

    public static void postInit() {
        AeStats.register();
        advancementTriggers = new AdvancementTriggers(CriteriaTriggers::func_192118_a);
        IRegistryContainer registries = Api.instance().registries();
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        ApiParts parts = definitions.parts();
        ApiBlocks blocks = definitions.blocks();
        ApiItems items = definitions.items();
        String interfaceGroup = parts.iface().func_199767_j().func_77658_a();
        String itemIoBusGroup = GuiText.IOBuses.getTranslationKey();
        String fluidIoBusGroup = GuiText.IOBusesFluids.getTranslationKey();
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        ((P2PTunnelRegistry)registries.p2pTunnel()).configure();
        Upgrades.CRAFTING.registerItem(parts.iface(), 1, interfaceGroup);
        Upgrades.CRAFTING.registerItem(blocks.iface(), 1, interfaceGroup);
        Upgrades.SPEED.registerItem(blocks.iOPort(), 3);
        Upgrades.REDSTONE.registerItem(blocks.iOPort(), 1);
        Upgrades.FUZZY.registerItem(parts.levelEmitter(), 1);
        Upgrades.CRAFTING.registerItem(parts.levelEmitter(), 1);
        Upgrades.FUZZY.registerItem(parts.importBus(), 1, itemIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.importBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.importBus(), 2, itemIoBusGroup);
        Upgrades.SPEED.registerItem(parts.importBus(), 4, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.fluidImportBus(), 2, fluidIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.fluidImportBus(), 1, fluidIoBusGroup);
        Upgrades.SPEED.registerItem(parts.fluidImportBus(), 4, fluidIoBusGroup);
        Upgrades.FUZZY.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.exportBus(), 2, itemIoBusGroup);
        Upgrades.SPEED.registerItem(parts.exportBus(), 4, itemIoBusGroup);
        Upgrades.CRAFTING.registerItem(parts.exportBus(), 1, itemIoBusGroup);
        Upgrades.CAPACITY.registerItem(parts.fluidExportBus(), 2, fluidIoBusGroup);
        Upgrades.REDSTONE.registerItem(parts.fluidExportBus(), 1, fluidIoBusGroup);
        Upgrades.SPEED.registerItem(parts.fluidExportBus(), 4, fluidIoBusGroup);
        Upgrades.FUZZY.registerItem(items.cell1k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell1k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell4k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell4k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell16k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell16k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.cell64k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.cell64k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell1k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell4k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell16k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.portableCell64k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell1k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell4k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell16k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.portableCell64k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.fluidCell1k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.fluidCell4k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.fluidCell16k(), 1, storageCellGroup);
        Upgrades.INVERTER.registerItem(items.fluidCell64k(), 1, storageCellGroup);
        Upgrades.FUZZY.registerItem(items.viewCell(), 1);
        Upgrades.INVERTER.registerItem(items.viewCell(), 1);
        Upgrades.FUZZY.registerItem(parts.storageBus(), 1);
        Upgrades.INVERTER.registerItem(parts.storageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.storageBus(), 5);
        Upgrades.INVERTER.registerItem(parts.fluidStorageBus(), 1);
        Upgrades.CAPACITY.registerItem(parts.fluidStorageBus(), 5);
        Upgrades.FUZZY.registerItem(parts.formationPlane(), 1);
        Upgrades.INVERTER.registerItem(parts.formationPlane(), 1);
        Upgrades.CAPACITY.registerItem(parts.formationPlane(), 5);
        Upgrades.FUZZY.registerItem(items.massCannon(), 1);
        Upgrades.INVERTER.registerItem(items.massCannon(), 1);
        Upgrades.SPEED.registerItem(items.massCannon(), 4);
        Upgrades.SPEED.registerItem(blocks.molecularAssembler(), 5);
        Upgrades.SPEED.registerItem(blocks.inscriber(), 3);
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.wireless().registerWirelessHandler((IWirelessTermHandler)terminal));
        items.chargedStaff().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 320.0));
        items.portableCell1k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 800.0));
        items.portableCell4k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 800.0));
        items.portableCell16k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 800.0));
        items.portableCell64k().maybeItem().ifPresent(chargedStaff -> registries.charger().addChargeRate((Item)chargedStaff, 800.0));
        items.colorApplicator().maybeItem().ifPresent(colorApplicator -> registries.charger().addChargeRate((Item)colorApplicator, 800.0));
        items.wirelessTerminal().maybeItem().ifPresent(terminal -> registries.charger().addChargeRate((Item)terminal, 8000.0));
        items.entropyManipulator().maybeItem().ifPresent(entropyManipulator -> registries.charger().addChargeRate((Item)entropyManipulator, 8000.0));
        items.massCannon().maybeItem().ifPresent(massCannon -> registries.charger().addChargeRate((Item)massCannon, 8000.0));
        blocks.energyCell().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((Item)cell, 8000.0));
        blocks.energyCellDense().maybeItem().ifPresent(cell -> registries.charger().addChargeRate((Item)cell, 16000.0));
        IMovableRegistry mr = registries.movable();
        mr.blacklistBlock(Blocks.field_150357_h);
        mr.whiteListTileEntity(BannerTileEntity.class);
        mr.whiteListTileEntity(BeaconTileEntity.class);
        mr.whiteListTileEntity(BrewingStandTileEntity.class);
        mr.whiteListTileEntity(ChestTileEntity.class);
        mr.whiteListTileEntity(CommandBlockTileEntity.class);
        mr.whiteListTileEntity(ComparatorTileEntity.class);
        mr.whiteListTileEntity(DaylightDetectorTileEntity.class);
        mr.whiteListTileEntity(DispenserTileEntity.class);
        mr.whiteListTileEntity(DropperTileEntity.class);
        mr.whiteListTileEntity(EnchantingTableTileEntity.class);
        mr.whiteListTileEntity(EnderChestTileEntity.class);
        mr.whiteListTileEntity(EndPortalTileEntity.class);
        mr.whiteListTileEntity(FurnaceTileEntity.class);
        mr.whiteListTileEntity(HopperTileEntity.class);
        mr.whiteListTileEntity(MobSpawnerTileEntity.class);
        mr.whiteListTileEntity(PistonTileEntity.class);
        mr.whiteListTileEntity(ShulkerBoxTileEntity.class);
        mr.whiteListTileEntity(SignTileEntity.class);
        mr.whiteListTileEntity(SkullTileEntity.class);
        mr.whiteListTileEntity(AEBaseTileEntity.class);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerTextures(TextureStitchEvent.Pre event) {
        SkyChestTESR.registerTextures(event);
        InscriberTESR.registerTexture(event);
    }

    public void registerCommands(FMLServerStartingEvent evt) {
        new AECommand().register((CommandDispatcher<CommandSource>)evt.getServer().func_195571_aL().func_197054_a());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IItemColorRegistrationComponent.class).forEachRemaining(c -> c.register(event.getItemColors(), event.getBlockColors()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleModelBake(ModelBakeEvent event) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IModelBakeComponent.class).forEachRemaining(c -> c.onModelBakeEvent(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientEvents() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerParticleFactories);
        modEventBus.addListener(this::registerTextures);
        modEventBus.addListener(this::modelRegistryEvent);
        modEventBus.addListener(this::registerItemColors);
        modEventBus.addListener(this::handleModelBake);
    }

    public void addWorldGenToBiome(BiomeLoadingEvent e) {
        this.addMeteoriteWorldGen(e);
        this.addQuartzWorldGen(e);
    }

    private void addMeteoriteWorldGen(BiomeLoadingEvent e) {
        if (Registration.shouldGenerateIn(e.getName(), AEFeature.METEORITE_WORLD_GEN, IWorldGen.WorldGenType.METEORITES, e.getCategory())) {
            e.getGeneration().func_242516_a(MeteoriteStructure.CONFIGURED_INSTANCE);
        }
    }

    private void addQuartzWorldGen(BiomeLoadingEvent e) {
        if (Registration.shouldGenerateIn(e.getName(), AEFeature.CERTUS_QUARTZ_WORLD_GEN, IWorldGen.WorldGenType.CERTUS_QUARTZ, e.getCategory())) {
            e.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, quartzOreFeature);
            if (AEConfig.instance().isFeatureEnabled(AEFeature.CHARGED_CERTUS_ORE)) {
                e.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, chargedQuartzOreFeature);
            }
        }
    }

    static boolean shouldGenerateIn(ResourceLocation id, AEFeature feature, IWorldGen.WorldGenType worldGenType, Biome.Category category) {
        if (id == null) {
            return false;
        }
        if (!AEConfig.instance().isFeatureEnabled(feature)) {
            AELog.debug("Not generating %s in %s because the feature is disabled", new Object[]{feature, id});
            return false;
        }
        if (category == Biome.Category.THEEND || category == Biome.Category.NETHER || category == Biome.Category.NONE) {
            AELog.debug("Not generating %s in %s because it's of category %s", new Object[]{feature, id, category});
            return false;
        }
        if (Api.instance().registries().worldgen().isWorldGenDisabledForBiome(worldGenType, id)) {
            AELog.debug("Not generating %s in %s because the biome is blacklisted by another mod or the config", new Object[]{feature, id});
            return false;
        }
        return true;
    }

    private static ConfiguredFeature<?, ?> registerQuartzOreFeature() {
        BlockState quartzOreState = Api.instance().definitions().blocks().quartzOre().block().func_176223_P();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("quartz_ore").toString(), (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, quartzOreState, AEConfig.instance().getQuartzOresPerCluster())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(12, 12, 72))).func_242728_a()).func_242731_b(AEConfig.instance().getQuartzOresClusterAmount()));
    }

    private static ConfiguredFeature<?, ?> registerChargedQuartzOreFeature() {
        BlockState quartzOreState = Api.instance().definitions().blocks().quartzOre().block().func_176223_P();
        BlockState chargedQuartzOreState = Api.instance().definitions().blocks().quartzOreCharged().block().func_176223_P();
        return ConfiguredFeaturesAccessor.register(AppEng.makeId("charged_quartz_ore").toString(), ChargedQuartzOreFeature.INSTANCE.func_225566_b_(new ChargedQuartzOreConfig(quartzOreState, chargedQuartzOreState, AEConfig.instance().getSpawnChargedChance())).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_)));
    }

    public void registerDimension(RegistryEvent.NewRegistry e) {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)SpatialStorageDimensionIds.CHUNK_GENERATOR_ID, SpatialStorageChunkGenerator.CODEC);
    }
}

