/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.AEFeature;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ItemDefinition
implements IItemDefinition {
    private final String identifier;
    private final Item item;
    private final Set<AEFeature> features;

    public ItemDefinition(String registryName, Item item, Set<AEFeature> features) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)registryName) ? 1 : 0) != 0, (Object)"registryName");
        this.identifier = registryName;
        this.item = item;
        this.features = ImmutableSet.copyOf(features);
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    public final Item item() {
        return this.item;
    }

    @Override
    public ItemStack stack(int stackSize) {
        return new ItemStack((IItemProvider)this.item, stackSize);
    }

    @Override
    public Set<AEFeature> features() {
        return this.features;
    }

    @Override
    public final boolean isSameAs(ItemStack comparableStack) {
        return Platform.itemComparisons().isEqualItemType(comparableStack, this.stack(1));
    }
}

