/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CraftAmountContainer;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class InventoryActionPacket
extends BasePacket {
    private final InventoryAction action;
    private final int slot;
    private final long id;
    private final IAEItemStack slotItem;

    public InventoryActionPacket(PacketBuffer stream) {
        this.action = InventoryAction.values()[stream.readInt()];
        this.slot = stream.readInt();
        this.id = stream.readLong();
        boolean hasItem = stream.readBoolean();
        this.slotItem = hasItem ? AEItemStack.fromPacket(stream) : null;
    }

    public InventoryActionPacket(InventoryAction action, int slot, IAEItemStack slotItem) {
        if (Platform.isClient()) {
            throw new IllegalStateException("invalid packet, client cannot post inv actions with stacks.");
        }
        this.action = action;
        this.slot = slot;
        this.id = 0L;
        this.slotItem = slotItem;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(this.id);
        if (slotItem == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            slotItem.writeToPacket(data);
        }
        this.configureWrite(data);
    }

    public InventoryActionPacket(InventoryAction action, int slot, long id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.slotItem = null;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeInt(action.ordinal());
        data.writeInt(slot);
        data.writeLong(id);
        data.writeBoolean(false);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity sender = (ServerPlayerEntity)player;
        if (sender.field_71070_bA instanceof AEBaseContainer) {
            AEBaseContainer baseContainer = (AEBaseContainer)sender.field_71070_bA;
            if (this.action == InventoryAction.AUTO_CRAFT) {
                ContainerLocator locator = baseContainer.getLocator();
                if (locator != null) {
                    ContainerOpener.openContainer(CraftAmountContainer.TYPE, player, locator);
                    if (sender.field_71070_bA instanceof CraftAmountContainer) {
                        CraftAmountContainer cca = (CraftAmountContainer)sender.field_71070_bA;
                        if (baseContainer.getTargetStack() != null) {
                            cca.getCraftingItem().func_75215_d(baseContainer.getTargetStack().asItemStackRepresentation());
                            cca.setItemToCraft(baseContainer.getTargetStack());
                        }
                        cca.func_75142_b();
                    }
                }
            } else {
                baseContainer.doAction(sender, this.action, this.slot, this.id);
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        if (this.action == InventoryAction.UPDATE_HAND) {
            if (this.slotItem == null) {
                AppEng.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(ItemStack.field_190927_a);
            } else {
                AppEng.proxy.getPlayers().get((int)0).field_71071_by.func_70437_b(this.slotItem.createItemStack());
            }
        }
    }
}

