/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.CraftConfirmScreen;
import appeng.client.gui.implementations.CraftingCPUScreen;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.implementations.NetworkStatusScreen;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;

public class MEInventoryUpdatePacket
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    @Nullable
    private final List<IAEItemStack> list;
    private final byte ref;
    @Nullable
    private final PacketBuffer data;
    private int writtenBytes = 0;
    private boolean empty = true;

    public MEInventoryUpdatePacket(PacketBuffer stream) {
        this.data = null;
        this.list = new ArrayList<IAEItemStack>();
        this.ref = stream.readByte();
        while (stream.readableBytes() > 0) {
            this.list.add(AEItemStack.fromPacket(stream));
        }
        this.empty = this.list.isEmpty();
    }

    public MEInventoryUpdatePacket() throws IOException {
        this(0);
    }

    public MEInventoryUpdatePacket(byte ref) throws IOException {
        this.ref = ref;
        this.data = new PacketBuffer(Unpooled.buffer((int)2048));
        this.data.writeInt(this.getPacketID());
        this.data.writeByte((int)this.ref);
        this.list = null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, PlayerEntity player) {
        Screen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof CraftConfirmScreen) {
            ((CraftConfirmScreen)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof CraftingCPUScreen) {
            ((CraftingCPUScreen)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof MEMonitorableScreen) {
            ((MEMonitorableScreen)gs).postUpdate(this.list);
        }
        if (gs instanceof NetworkStatusScreen) {
            ((NetworkStatusScreen)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public IPacket<?> toPacket(NetworkDirection direction) {
        this.configureWrite(this.data);
        return super.toPacket(direction);
    }

    public void appendItem(IAEItemStack is) throws IOException, BufferOverflowException {
        PacketBuffer tmp = new PacketBuffer(Unpooled.buffer((int)2048));
        is.writeToPacket(tmp);
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.data.writeBytes(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public int getLength() {
        return this.data.readableBytes();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

