/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.AEColor;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;

public final class BlockRecolorer {
    private static final BiMap<AEColor, Block> STAINED_GLASS_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196807_gj).put((Object)AEColor.ORANGE, (Object)Blocks.field_196808_gk).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196809_gl).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196810_gm).put((Object)AEColor.YELLOW, (Object)Blocks.field_196811_gn).put((Object)AEColor.LIME, (Object)Blocks.field_196812_go).put((Object)AEColor.PINK, (Object)Blocks.field_196813_gp).put((Object)AEColor.GRAY, (Object)Blocks.field_196815_gq).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196816_gr).put((Object)AEColor.CYAN, (Object)Blocks.field_196818_gs).put((Object)AEColor.PURPLE, (Object)Blocks.field_196819_gt).put((Object)AEColor.BLUE, (Object)Blocks.field_196820_gu).put((Object)AEColor.BROWN, (Object)Blocks.field_196821_gv).put((Object)AEColor.GREEN, (Object)Blocks.field_196822_gw).put((Object)AEColor.RED, (Object)Blocks.field_196823_gx).put((Object)AEColor.BLACK, (Object)Blocks.field_196824_gy).build());
    private static final BiMap<AEColor, Block> STAINED_GLASS_PANE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196825_gz).put((Object)AEColor.ORANGE, (Object)Blocks.field_196758_gA).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196759_gB).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196760_gC).put((Object)AEColor.YELLOW, (Object)Blocks.field_196761_gD).put((Object)AEColor.LIME, (Object)Blocks.field_196763_gE).put((Object)AEColor.PINK, (Object)Blocks.field_196764_gF).put((Object)AEColor.GRAY, (Object)Blocks.field_196765_gG).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196767_gH).put((Object)AEColor.CYAN, (Object)Blocks.field_196768_gI).put((Object)AEColor.PURPLE, (Object)Blocks.field_196769_gJ).put((Object)AEColor.BLUE, (Object)Blocks.field_196771_gK).put((Object)AEColor.BROWN, (Object)Blocks.field_196773_gL).put((Object)AEColor.GREEN, (Object)Blocks.field_196774_gM).put((Object)AEColor.RED, (Object)Blocks.field_196775_gN).put((Object)AEColor.BLACK, (Object)Blocks.field_196776_gO).build());
    private static final BiMap<AEColor, Block> WOOL_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196556_aL).put((Object)AEColor.ORANGE, (Object)Blocks.field_196557_aM).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196558_aN).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196559_aO).put((Object)AEColor.YELLOW, (Object)Blocks.field_196560_aP).put((Object)AEColor.LIME, (Object)Blocks.field_196561_aQ).put((Object)AEColor.PINK, (Object)Blocks.field_196562_aR).put((Object)AEColor.GRAY, (Object)Blocks.field_196563_aS).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196564_aT).put((Object)AEColor.CYAN, (Object)Blocks.field_196565_aU).put((Object)AEColor.PURPLE, (Object)Blocks.field_196566_aV).put((Object)AEColor.BLUE, (Object)Blocks.field_196567_aW).put((Object)AEColor.BROWN, (Object)Blocks.field_196568_aX).put((Object)AEColor.GREEN, (Object)Blocks.field_196569_aY).put((Object)AEColor.RED, (Object)Blocks.field_196570_aZ).put((Object)AEColor.BLACK, (Object)Blocks.field_196602_ba).build());
    private static final BiMap<AEColor, Block> BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196784_gT).put((Object)AEColor.ORANGE, (Object)Blocks.field_196786_gU).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196788_gV).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196790_gW).put((Object)AEColor.YELLOW, (Object)Blocks.field_196792_gX).put((Object)AEColor.LIME, (Object)Blocks.field_196794_gY).put((Object)AEColor.PINK, (Object)Blocks.field_196796_gZ).put((Object)AEColor.GRAY, (Object)Blocks.field_196826_ha).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196827_hb).put((Object)AEColor.CYAN, (Object)Blocks.field_196829_hc).put((Object)AEColor.PURPLE, (Object)Blocks.field_196831_hd).put((Object)AEColor.BLUE, (Object)Blocks.field_196833_he).put((Object)AEColor.BROWN, (Object)Blocks.field_196835_hf).put((Object)AEColor.GREEN, (Object)Blocks.field_196837_hg).put((Object)AEColor.RED, (Object)Blocks.field_196839_hh).put((Object)AEColor.BLACK, (Object)Blocks.field_196841_hi).build());
    private static final BiMap<AEColor, Block> WALL_BANNER_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196843_hj).put((Object)AEColor.ORANGE, (Object)Blocks.field_196845_hk).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196847_hl).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196849_hm).put((Object)AEColor.YELLOW, (Object)Blocks.field_196851_hn).put((Object)AEColor.LIME, (Object)Blocks.field_196853_ho).put((Object)AEColor.PINK, (Object)Blocks.field_196855_hp).put((Object)AEColor.GRAY, (Object)Blocks.field_196857_hq).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196859_hr).put((Object)AEColor.CYAN, (Object)Blocks.field_196861_hs).put((Object)AEColor.PURPLE, (Object)Blocks.field_196863_ht).put((Object)AEColor.BLUE, (Object)Blocks.field_196865_hu).put((Object)AEColor.BROWN, (Object)Blocks.field_196867_hv).put((Object)AEColor.GREEN, (Object)Blocks.field_196869_hw).put((Object)AEColor.RED, (Object)Blocks.field_196871_hx).put((Object)AEColor.BLACK, (Object)Blocks.field_196873_hy).build());
    private static final BiMap<AEColor, Block> CARPET_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196724_fH).put((Object)AEColor.ORANGE, (Object)Blocks.field_196725_fI).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196727_fJ).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196729_fK).put((Object)AEColor.YELLOW, (Object)Blocks.field_196731_fL).put((Object)AEColor.LIME, (Object)Blocks.field_196733_fM).put((Object)AEColor.PINK, (Object)Blocks.field_196735_fN).put((Object)AEColor.GRAY, (Object)Blocks.field_196737_fO).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196739_fP).put((Object)AEColor.CYAN, (Object)Blocks.field_196741_fQ).put((Object)AEColor.PURPLE, (Object)Blocks.field_196743_fR).put((Object)AEColor.BLUE, (Object)Blocks.field_196745_fS).put((Object)AEColor.BROWN, (Object)Blocks.field_196747_fT).put((Object)AEColor.GREEN, (Object)Blocks.field_196749_fU).put((Object)AEColor.RED, (Object)Blocks.field_196751_fV).put((Object)AEColor.BLACK, (Object)Blocks.field_196753_fW).build());
    private static final BiMap<AEColor, Block> TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196777_fo).put((Object)AEColor.ORANGE, (Object)Blocks.field_196778_fp).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196780_fq).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196782_fr).put((Object)AEColor.YELLOW, (Object)Blocks.field_196783_fs).put((Object)AEColor.LIME, (Object)Blocks.field_196785_ft).put((Object)AEColor.PINK, (Object)Blocks.field_196787_fu).put((Object)AEColor.GRAY, (Object)Blocks.field_196789_fv).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196791_fw).put((Object)AEColor.CYAN, (Object)Blocks.field_196793_fx).put((Object)AEColor.PURPLE, (Object)Blocks.field_196795_fy).put((Object)AEColor.BLUE, (Object)Blocks.field_196797_fz).put((Object)AEColor.BROWN, (Object)Blocks.field_196719_fA).put((Object)AEColor.GREEN, (Object)Blocks.field_196720_fB).put((Object)AEColor.RED, (Object)Blocks.field_196721_fC).put((Object)AEColor.BLACK, (Object)Blocks.field_196722_fD).build());
    private static final BiMap<AEColor, Block> GLAZED_TERRACOTTA_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_192427_dB).put((Object)AEColor.ORANGE, (Object)Blocks.field_192428_dC).put((Object)AEColor.MAGENTA, (Object)Blocks.field_192429_dD).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_192430_dE).put((Object)AEColor.YELLOW, (Object)Blocks.field_192431_dF).put((Object)AEColor.LIME, (Object)Blocks.field_192432_dG).put((Object)AEColor.PINK, (Object)Blocks.field_192433_dH).put((Object)AEColor.GRAY, (Object)Blocks.field_192434_dI).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196876_iu).put((Object)AEColor.CYAN, (Object)Blocks.field_192436_dK).put((Object)AEColor.PURPLE, (Object)Blocks.field_192437_dL).put((Object)AEColor.BLUE, (Object)Blocks.field_192438_dM).put((Object)AEColor.BROWN, (Object)Blocks.field_192439_dN).put((Object)AEColor.GREEN, (Object)Blocks.field_192440_dO).put((Object)AEColor.RED, (Object)Blocks.field_192441_dP).put((Object)AEColor.BLACK, (Object)Blocks.field_192442_dQ).build());
    private static final BiMap<AEColor, Block> CONCRETE_BY_COLOR = EnumHashBiMap.create((Map)ImmutableMap.builder().put((Object)AEColor.WHITE, (Object)Blocks.field_196828_iC).put((Object)AEColor.ORANGE, (Object)Blocks.field_196830_iD).put((Object)AEColor.MAGENTA, (Object)Blocks.field_196832_iE).put((Object)AEColor.LIGHT_BLUE, (Object)Blocks.field_196834_iF).put((Object)AEColor.YELLOW, (Object)Blocks.field_196836_iG).put((Object)AEColor.LIME, (Object)Blocks.field_196838_iH).put((Object)AEColor.PINK, (Object)Blocks.field_196840_iI).put((Object)AEColor.GRAY, (Object)Blocks.field_196842_iJ).put((Object)AEColor.LIGHT_GRAY, (Object)Blocks.field_196844_iK).put((Object)AEColor.CYAN, (Object)Blocks.field_196846_iL).put((Object)AEColor.PURPLE, (Object)Blocks.field_196848_iM).put((Object)AEColor.BLUE, (Object)Blocks.field_196850_iN).put((Object)AEColor.BROWN, (Object)Blocks.field_196852_iO).put((Object)AEColor.GREEN, (Object)Blocks.field_196854_iP).put((Object)AEColor.RED, (Object)Blocks.field_196856_iQ).put((Object)AEColor.BLACK, (Object)Blocks.field_196858_iR).build());
    private static final List<RecolorableBlockGroup> BLOCK_GROUPS = ImmutableList.of((Object)new RecolorableBlockGroup(Blocks.field_150359_w, STAINED_GLASS_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_150410_aZ, STAINED_GLASS_PANE_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_196556_aL, WOOL_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_196784_gT, BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_196843_hj, WALL_BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_196724_fH, CARPET_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.field_150405_ch, TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, GLAZED_TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, CONCRETE_BY_COLOR));

    private BlockRecolorer() {
    }

    public static Block recolor(Block block, AEColor newColor) {
        Preconditions.checkNotNull((Object)block);
        for (RecolorableBlockGroup group : BLOCK_GROUPS) {
            if (group.uncoloredVariant != block && !group.coloredVariants.containsValue((Object)block)) continue;
            Block newBlock = (Block)group.coloredVariants.get((Object)newColor);
            if (newBlock == null) {
                newBlock = group.uncoloredVariant != null ? group.uncoloredVariant : block;
            }
            return newBlock;
        }
        return block;
    }

    private static class RecolorableBlockGroup {
        final Block uncoloredVariant;
        final BiMap<AEColor, Block> coloredVariants;

        public RecolorableBlockGroup(Block uncoloredVariant, BiMap<AEColor, Block> coloredVariants) {
            this.uncoloredVariant = uncoloredVariant;
            this.coloredVariants = coloredVariants;
        }
    }
}

