/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.FuzzyMode;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.MEPortableCellContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.contents.PortableCellViewer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class PortableCellItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IGuiItem {
    private final StorageTier tier;

    public PortableCellItem(StorageTier tier, Item.Properties props) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.tier = tier;
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity player, Hand hand) {
        ContainerOpener.openContainer(MEPortableCellContainer.TYPE, player, ContainerLocator.forHand(player, hand));
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        super.func_77624_a(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.tier.getBytes();
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.tier.getBytesPerType();
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.tier.getTypes();
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.func_196082_o().func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.func_196082_o().func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, int playerInventorySlot, World w, BlockPos pos) {
        return new PortableCellViewer(is, playerInventorySlot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static enum StorageTier {
        SIZE_1K(512, 54, 8),
        SIZE_4K(2048, 45, 32),
        SIZE_16K(8192, 36, 128),
        SIZE_64K(16834, 27, 512);

        private final int bytes;
        private final int types;
        private final int bytesPerType;

        private StorageTier(int bytes, int types, int bytesPerType) {
            this.bytes = bytes;
            this.types = types;
            this.bytesPerType = bytesPerType;
        }

        public int getBytes() {
            return this.bytes;
        }

        public int getTypes() {
            return this.types;
        }

        public int getBytesPerType() {
            return this.bytesPerType;
        }
    }
}

