/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class StateApplier<T extends Comparable<T>> {
    private final Property<T> property;
    private final T value;

    private StateApplier(Property<T> property, String valueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, valueName);
    }

    <SH extends StateHolder<O, SH>, O> SH apply(SH state) {
        return (SH)((StateHolder)state.func_206870_a(this.property, this.value));
    }

    void writeToPacket(PacketBuffer buffer) {
        buffer.func_180714_a(this.property.func_177701_a());
        buffer.func_180714_a(this.property.func_177702_a(this.value));
    }

    static StateApplier<?> create(StateContainer<?, ?> stateContainer, String propertyName, String value) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateContainer, propertyName);
        return new StateApplier(property, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    static StateApplier<?> readFromPacket(StateContainer<?, ?> stateContainer, PacketBuffer buffer) {
        String propertyName = buffer.func_218666_n();
        String value = buffer.func_218666_n();
        return StateApplier.create(stateContainer, propertyName, value);
    }
}

